/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.mail.dao.MsgMailSendRecordMapper;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendRecordPageDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailSendRecord;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendRecordDbService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendRecordService;
import com.jxdinfo.hussar.msg.mail.vo.MailChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.mail.vo.MsgMailSendRecordQueryVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgMailSendRecordDbServiceImpl
extends HussarServiceImpl<MsgMailSendRecordMapper, MsgMailSendRecord>
implements MsgMailSendRecordDbService,
MsgMailSendRecordService {
    @Autowired
    private MsgMailSendRecordMapper msgMailSendRecordMapper;
    @Autowired
    private MsgMailChannelService msgMailChannelService;

    public IPage<MailSendRecordDto> listPage(Page page, MsgMailSendRecordPageDto pageDto) {
        pageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppName()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        pageDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)pageDto.getSceneName()));
        pageDto.setReciverName(SqlQueryUtil.transferSpecialChar((String)pageDto.getReciverName()));
        Page sendRecordDtoPage = new Page(page.getCurrent(), page.getSize());
        List<MailSendRecordDto> mailSendRecordDtos = this.msgMailSendRecordMapper.listPage((Page<MailSendRecordDto>)sendRecordDtoPage, pageDto);
        for (MailSendRecordDto mailSendRecordDto : mailSendRecordDtos) {
            String tempMailParams = mailSendRecordDto.getTempMailParams();
            Map mailParams = (Map)JSON.parseObject((String)tempMailParams, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            mailSendRecordDto.setMailParams(mailParams);
            String recoverMail = mailSendRecordDto.getReciverMail();
            if (!HussarUtils.isNotEmpty((Object)recoverMail)) continue;
            mailSendRecordDto.setReciverMail(String.join((CharSequence)";", (CharSequence[])Arrays.stream(recoverMail.split(";")).map(r -> r.replaceAll("(\\S{2})\\S*(@)(\\S*)", "$1****$2$3")).toArray(String[]::new)));
        }
        sendRecordDtoPage.setRecords(mailSendRecordDtos);
        return sendRecordDtoPage;
    }

    public MailSendRecordDto findById(String id) {
        MsgMailSendRecord msgMailSendRecord = (MsgMailSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgMailSendRecord::getId, (Object)Long.valueOf(id)));
        return (MailSendRecordDto)HussarUtils.copy((Object)msgMailSendRecord, MailSendRecordDto.class);
    }

    public boolean saveRecord(MailSendRecordDto mailSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(mailSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)mailSendRecordDto.getErrorContactInfos())) {
            mailSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", mailSendRecordDto.getErrorContactInfos()));
        }
        MsgMailSendRecord msgMailSendRecord = (MsgMailSendRecord)HussarUtils.copy((Object)mailSendRecordDto, MsgMailSendRecord.class);
        msgMailSendRecord.setMailParams(JSON.toJSONString((Object)mailSendRecordDto.getMailParams()));
        return super.save((BaseEntity)msgMailSendRecord);
    }

    public List<MailChannelSendStatisticsVo> sendStatistics(MsgMailSendRecordQueryVo queryDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgMailSendRecordMapper.listSendRecordStatusCount(queryDto.getBeginTime(), queryDto.getEndTime(), queryDto.getChannelNo());
        ArrayList<MailChannelSendStatisticsVo> sendStatisticsVos = new ArrayList<MailChannelSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.msgMailChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                MailChannelSendStatisticsVo sendStatisticsVo = MsgMailSendRecordDbServiceImpl.getMailChannelSendStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgMailSendRecordMapper.listChannels();
        Map channelNoAndName = this.msgMailChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    private static MailChannelSendStatisticsVo getMailChannelSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        MailChannelSendStatisticsVo sendStatisticsVo = new MailChannelSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<MailChannelSendStatisticsVo.MailChannelSendStatisticAgg> sendStatisticAggList = MsgMailSendRecordDbServiceImpl.getMailChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<MailChannelSendStatisticsVo.MailChannelSendStatisticAgg> getMailChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<MailChannelSendStatisticsVo.MailChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<MailChannelSendStatisticsVo.MailChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            MailChannelSendStatisticsVo.MailChannelSendStatisticAgg sendStatisticAgg = new MailChannelSendStatisticsVo.MailChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

