/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.cp.dao.MsgCpSendRecordMapper;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordPageDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpSendRecord;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.service.CpSendRecordService;
import com.jxdinfo.hussar.msg.cp.service.MsgCpSendRecordDbService;
import com.jxdinfo.hussar.msg.cp.vo.CpChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.cp.vo.MsgCpSendRecordVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgCpSendRecordDbServiceImpl
extends HussarServiceImpl<MsgCpSendRecordMapper, MsgCpSendRecord>
implements MsgCpSendRecordDbService,
CpSendRecordService {
    @Autowired
    private MsgCpSendRecordMapper msgCpSendRecordMapper;
    @Autowired
    private CpChannelService cpChannelService;

    public IPage<MsgCpSendRecordVo> listPage(Page page, CpSendRecordPageDto pageDto) {
        pageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppName()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        pageDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)pageDto.getSceneName()));
        pageDto.setCorpName(SqlQueryUtil.transferSpecialChar((String)pageDto.getCorpName()));
        pageDto.setAgentName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAgentName()));
        Page sendRecordVoPage = new Page(page.getCurrent(), page.getSize());
        List<MsgCpSendRecordVo> msgCpSendRecordVos = this.msgCpSendRecordMapper.listPage((Page<MsgCpSendRecordVo>)sendRecordVoPage, pageDto);
        for (MsgCpSendRecordVo msgCpSendRecordVo : msgCpSendRecordVos) {
            msgCpSendRecordVo.setToUser(ContactInfoEncryptUtils.receiveAddressEncrypt((String)msgCpSendRecordVo.getToUser()));
        }
        sendRecordVoPage.setRecords(msgCpSendRecordVos);
        return sendRecordVoPage;
    }

    public CpSendRecordDto findById(String id) {
        MsgCpSendRecord msgCpSendRecord = (MsgCpSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgCpSendRecord::getId, (Object)Long.valueOf(id)));
        return (CpSendRecordDto)HussarUtils.copy((Object)msgCpSendRecord, CpSendRecordDto.class);
    }

    public List<CpChannelSendStatisticsVo> sendStatistics(CpSendRecordPageDto pageDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgCpSendRecordMapper.listSendRecordStatusCount(pageDto.getBeginTime(), pageDto.getEndTime(), pageDto.getChannelNo());
        ArrayList<CpChannelSendStatisticsVo> sendStatisticsVos = new ArrayList<CpChannelSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.cpChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                CpChannelSendStatisticsVo sendStatisticsVo = MsgCpSendRecordDbServiceImpl.getCpChannelSendStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgCpSendRecordMapper.listChannels();
        Map channelNoAndName = this.cpChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    public void saveRecord(CpSendRecordDto cpSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(cpSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)cpSendRecordDto.getErrorContactInfos())) {
            cpSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", cpSendRecordDto.getErrorContactInfos()));
        }
        super.save((BaseEntity)HussarUtils.copy((Object)cpSendRecordDto, MsgCpSendRecord.class));
    }

    private static CpChannelSendStatisticsVo getCpChannelSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        CpChannelSendStatisticsVo sendStatisticsVo = new CpChannelSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<CpChannelSendStatisticsVo.CpChannelSendStatisticAgg> sendStatisticAggList = MsgCpSendRecordDbServiceImpl.getCpChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<CpChannelSendStatisticsVo.CpChannelSendStatisticAgg> getCpChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<CpChannelSendStatisticsVo.CpChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<CpChannelSendStatisticsVo.CpChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            CpChannelSendStatisticsVo.CpChannelSendStatisticAgg sendStatisticAgg = new CpChannelSendStatisticsVo.CpChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

