/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.apppush.dao.MsgAppPushSendRecordMapper;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordPageDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordQueryDto;
import com.jxdinfo.hussar.msg.apppush.model.MsgAppPushSendRecord;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.apppush.service.MsgAppPushSendRecordDbService;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushSendRecordQueryVo;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushSendRecordVo;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgAppPushSendRecordDbServiceImpl
extends HussarServiceImpl<MsgAppPushSendRecordMapper, MsgAppPushSendRecord>
implements MsgAppPushSendRecordDbService,
AppPushSendRecordService {
    @Autowired
    private MsgAppPushSendRecordMapper msgAppPushSendRecordMapper;
    @Autowired
    private AppPushChannelService appPushChannelService;

    public IPage<AppPushSendRecordVo> listPage(Page page, AppPushSendRecordPageDto pageDto) {
        pageDto.setMsgAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getMsgAppName()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        pageDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)pageDto.getSceneName()));
        pageDto.setTitle(SqlQueryUtil.transferSpecialChar((String)pageDto.getTitle()));
        pageDto.setContent(SqlQueryUtil.transferSpecialChar((String)pageDto.getContent()));
        Page sendRecordVoPage = new Page(page.getCurrent(), page.getSize());
        List<AppPushSendRecordVo> appPushSendRecordVos = this.msgAppPushSendRecordMapper.listPage((Page<AppPushSendRecordVo>)sendRecordVoPage, pageDto);
        for (AppPushSendRecordVo appPushSendRecordVo : appPushSendRecordVos) {
            appPushSendRecordVo.setTokenList(ContactInfoEncryptUtils.receiveAddressEncrypt((String)appPushSendRecordVo.getTokenList()));
        }
        sendRecordVoPage.setRecords(appPushSendRecordVos);
        return sendRecordVoPage;
    }

    public AppPushSendRecordQueryVo findById(String id) {
        MsgAppPushSendRecord msgAppPushSendRecord = (MsgAppPushSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgAppPushSendRecord::getId, (Object)Long.valueOf(id)));
        return (AppPushSendRecordQueryVo)HussarUtils.copy((Object)msgAppPushSendRecord, AppPushSendRecordQueryVo.class);
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgAppPushSendRecordMapper.listChannels();
        Map channelNoAndName = this.appPushChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    public List<AppPushChannelSendStatisticsVo> sendStatistics(AppPushSendRecordQueryDto queryDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgAppPushSendRecordMapper.listSendRecordStatusCount(queryDto.getBeginTime(), queryDto.getEndTime(), queryDto.getChannelNo());
        ArrayList<AppPushChannelSendStatisticsVo> sendStatisticsVos = new ArrayList<AppPushChannelSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.appPushChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                AppPushChannelSendStatisticsVo sendStatisticsVo = MsgAppPushSendRecordDbServiceImpl.getAppPushChannelSendStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public void saveRecord(AppPushSendRecordDto appPushSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(appPushSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)appPushSendRecordDto.getErrorContactInfos())) {
            appPushSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", appPushSendRecordDto.getErrorContactInfos()));
        }
        super.save((BaseEntity)HussarUtils.copy((Object)appPushSendRecordDto, MsgAppPushSendRecord.class));
    }

    private static AppPushChannelSendStatisticsVo getAppPushChannelSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        AppPushChannelSendStatisticsVo sendStatisticsVo = new AppPushChannelSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg> sendStatisticAggList = MsgAppPushSendRecordDbServiceImpl.getAppPushChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg> getAppPushChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg sendStatisticAgg = new AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

