/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.listener;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.factory.MsgSendExecutorFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgSendExecutor;
import com.jxdinfo.hussar.msg.util.RabbitReceiverUtil;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.stereotype.Component;

@Component
public class MsgRabbitListener
implements MessageListener {
    private static Logger logger = LoggerFactory.getLogger(MsgRabbitListener.class);

    public void onMessage(Message message) {
        String json = "";
        String sendType = "";
        try {
            json = new String(message.getBody(), StandardCharsets.UTF_8);
            RabbitReceiverUtil.preHandle(message, json);
            sendType = (String)message.getMessageProperties().getHeaders().get("send_type");
            logger.info("\u6d88\u606f\u4e2d\u5fc3: \u5f00\u59cb\u6d88\u8d39 {} \u961f\u5217\u6d88\u606f \u53d1\u9001\u65b9\u5f0f{}, \u6d88\u606f\u5185\u5bb9\uff1a{}", new Object[]{message.getMessageProperties().getConsumerQueue(), sendType, json});
            MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)json, MsgUnitySendDto.class);
            msgUnitySendDto.putExtendParams("__loginId", message.getMessageProperties().getHeader("login_id"));
            MsgSendExecutor sendExecutor = MsgSendExecutorFactory.getSendExecutor((String)sendType);
            sendExecutor.sendMessage(msgUnitySendDto);
        }
        catch (Exception e) {
            logger.error("\u6d88\u8d39 {} \u961f\u5217\u6d88\u606f\u53d1\u751f\u5f02\u5e38! \u53d1\u9001\u65b9\u5f0f{}, \u6d88\u606f\u5185\u5bb9\uff1a{}", new Object[]{message.getMessageProperties().getConsumerQueue(), sendType, json, e});
        }
    }
}

