/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.config;

import com.jxdinfo.hussar.msg.mq.service.RabbitMqElementService;
import com.jxdinfo.hussar.msg.send.listener.MsgRabbitListener;
import com.jxdinfo.hussar.msg.send.service.MsgSendExecutor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgRabbitMqInitFactory
implements InitializingBean {
    @Autowired
    private RabbitMqElementService rabbitMqElementService;
    @Autowired
    private RabbitAdmin rabbitAdmin;
    @Autowired
    private SimpleMessageListenerContainer container;
    @Autowired
    private MsgRabbitListener messageListener;
    @Autowired(required=false)
    private List<MsgSendExecutor> sendExecutors;

    public void afterPropertiesSet() {
        this.init();
    }

    private void init() {
        if (HussarUtils.isEmpty(this.sendExecutors)) {
            return;
        }
        List sendTypes = this.sendExecutors.stream().map(MsgSendExecutor::getSendType).collect(Collectors.toList());
        for (String sendType : sendTypes) {
            DirectExchange directExchange = this.initDirect(sendType);
            Queue queue = this.initQueue(sendType);
            this.rabbitAdmin.declareExchange((Exchange)directExchange);
            this.rabbitAdmin.declareQueue(queue);
            Binding binding = this.bindingExchangeQueue(sendType, directExchange, queue);
            this.rabbitAdmin.declareBinding(binding);
            this.createListener(queue);
        }
    }

    DirectExchange initDirect(String sendType) {
        return (DirectExchange)ExchangeBuilder.directExchange((String)this.rabbitMqElementService.getExchangeName(sendType, null)).durable(true).build();
    }

    public Queue initQueue(String sendType) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-queue-type", "classic");
        return new Queue(this.rabbitMqElementService.getQueueName(sendType, null), true, false, false, args);
    }

    public Binding bindingExchangeQueue(String sendType, DirectExchange directExchange, Queue queue) {
        String routeKey = this.rabbitMqElementService.getRoutingKeyName(sendType, null);
        Binding binding = BindingBuilder.bind((Queue)queue).to(directExchange).with(routeKey);
        return binding;
    }

    public void createListener(Queue queues) {
        this.container.addQueueNames(new String[]{queues.getName()});
        this.container.setMessageListener((MessageListener)this.messageListener);
        this.container.start();
    }
}

