/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.config;

import com.jxdinfo.hussar.msg.common.enums.QueueEnum;
import com.jxdinfo.hussar.msg.condition.RabbitCondition;
import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RabbitCondition.class})
public class NoticeRabbitMqConfig {
    @Autowired
    private QueueEnum.PropertiesServiceInjector propertiesServiceInjector;

    @Bean
    DirectExchange noticeDirect() {
        return (DirectExchange)ExchangeBuilder.directExchange((String)QueueEnum.QUEUE_MSG_NOTICE.getExchange()).durable(true).build();
    }

    @Bean
    public Queue noticeQueue() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-queue-type", "classic");
        return new Queue(QueueEnum.QUEUE_MSG_NOTICE.getName(), true, false, false, args);
    }

    @Bean
    Binding noticeBinding() {
        return BindingBuilder.bind((Queue)this.noticeQueue()).to(this.noticeDirect()).with(QueueEnum.QUEUE_MSG_NOTICE.getRouteKey());
    }
}

