/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.condition.RabbitCondition;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.msg.util.RabbitReceiverUtil;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RabbitCondition.class})
public class MailRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MailRabbitMqReceiver.class);
    @Autowired
    private MailPushThirdService mailPushThirdService;
    @Autowired
    private MsgUnitySendFrameService mailUnitySendServiceImpl;

    @RabbitHandler
    @RabbitListener(queues={"#{mailQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg_Mail json:{}", (Object)json);
            RabbitReceiverUtil.preHandle(message, json);
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)json).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)json, MsgUnitySendDto.class);
                this.mailUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                MailSendRecordDto record = (MailSendRecordDto)JSONObject.parseObject((String)json, MailSendRecordDto.class);
                if (record.getBath().booleanValue()) {
                    this.mailPushThirdService.bathSend(record);
                } else {
                    this.mailPushThirdService.send(record);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u670d\u52a1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

