/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.common.enums.QueueEnum;
import com.jxdinfo.hussar.msg.condition.RabbitCondition;
import com.jxdinfo.hussar.msg.mq.service.RabbitMqElementService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.service.MsgSmsSendAsyncService;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={RabbitCondition.class})
public class MsgSmsSendAsyncServiceImpl
implements MsgSmsSendAsyncService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitMqElementService rabbitMqElementService;

    public boolean sendSmsAsyncMsg(SmsSendRecordDto smsSendRecordDto) {
        String s = JSONObject.toJSONString((Object)smsSendRecordDto);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(this.rabbitMqElementService.getExchangeName(QueueEnum.QUEUE_MSG_SMS.getType(), smsSendRecordDto.getTenantCode()), this.rabbitMqElementService.getRoutingKeyName(QueueEnum.QUEUE_MSG_SMS.getType(), smsSendRecordDto.getTenantCode()), (Object)message);
        return true;
    }
}

