/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.config;

import com.jxdinfo.hussar.msg.common.enums.QueueEnum;
import com.jxdinfo.hussar.msg.condition.RabbitCondition;
import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RabbitCondition.class})
public class AppRabbitMqConfig {
    @Autowired
    private QueueEnum.PropertiesServiceInjector propertiesServiceInjector;

    @Bean
    DirectExchange appPushDirect() {
        return (DirectExchange)ExchangeBuilder.directExchange((String)QueueEnum.QUEUE_MSG_APPPUSH.getExchange()).durable(true).build();
    }

    @Bean
    public Queue appPushQueue() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-queue-type", "classic");
        return new Queue(QueueEnum.QUEUE_MSG_APPPUSH.getName(), true, false, false, args);
    }

    @Bean
    Binding appPushBinding() {
        return BindingBuilder.bind((Queue)this.appPushQueue()).to(this.appPushDirect()).with(QueueEnum.QUEUE_MSG_APPPUSH.getRouteKey());
    }
}

