/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.msg.util.RabbitReceiverUtil;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AppRabbitMqReceiver.class);
    @Autowired(required=false)
    private AppPushThirdService appPushThirdService;
    @Autowired
    private MsgUnitySendFrameService appPushUnitySendServiceImpl;

    @RabbitHandler
    @RabbitListener(queues={"#{appPushQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg apppush json:{}", (Object)json);
            RabbitReceiverUtil.preHandle(message, json);
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)json).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)json, MsgUnitySendDto.class);
                this.appPushUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                AppPushSendRecordDto appPushSendRecord = (AppPushSendRecordDto)JSONObject.parseObject((String)json, AppPushSendRecordDto.class);
                boolean b = this.appPushThirdService.sendPushTimMsg(appPushSendRecord);
                logger.info("msg apppush res:{}", (Object)b);
            }
        }
        catch (Exception e) {
            logger.error("app\u63a8\u9001\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

