/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.msg.util.RabbitReceiverUtil;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppImRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AppImRabbitMqReceiver.class);
    @Autowired(required=false)
    private AppImPushThirdService appImPushThirdService;
    @Autowired
    private MsgUnitySendFrameService appImUnitySendServiceImpl;

    @RabbitHandler
    @RabbitListener(queues={"#{appImQueue.name}"})
    public void handlePay(Message message) {
        try {
            logger.info(String.valueOf(message));
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg app im json:{}", (Object)json);
            RabbitReceiverUtil.preHandle(message, json);
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)json).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)json, MsgUnitySendDto.class);
                this.appImUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                AppImSendRecordDto record = (AppImSendRecordDto)JSONObject.parseObject((String)json, AppImSendRecordDto.class);
                switch (AppImMsgTypeEnum.getByCode((Integer)record.getType())) {
                    case TEXT: {
                        this.appImPushThirdService.sendTextTimMsg(record);
                        break;
                    }
                    case ARTICLE: {
                        this.appImPushThirdService.sendArticleTimMsg(record);
                        break;
                    }
                    case IMG: {
                        this.appImPushThirdService.sendImgTimMsg(record);
                        break;
                    }
                    case FILE: {
                        this.appImPushThirdService.sendFileTimMsg(record);
                        break;
                    }
                    default: {
                        logger.error("\u9519\u8bef\u7684app_im\u6d88\u606f\u7c7b\u578b");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("app_im\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

