/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.common.enums.QueueEnum;
import com.jxdinfo.hussar.msg.mq.service.RabbitMqElementService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendAsyncService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgUnitySendAsyncServiceImpl
implements MsgUnitySendAsyncService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitMqElementService rabbitMqElementService;

    public boolean sendUnityAsyncMsg(MsgUnitySendDto msgUnitySendDto) {
        List sendTypes = msgUnitySendDto.getSendTypes();
        String s = JSON.toJSONString((Object)msgUnitySendDto);
        Message message = new Message(s.getBytes(), new MessageProperties());
        for (String sendType : sendTypes) {
            QueueEnum queueEnumByType = QueueEnum.getQueueEnumByType((String)sendType);
            if (HussarUtils.isNotEmpty((Object)queueEnumByType)) {
                this.rabbitTemplate.convertAndSend(this.rabbitMqElementService.getExchangeName(sendType, msgUnitySendDto.getTenantCode()), this.rabbitMqElementService.getRoutingKeyName(sendType, msgUnitySendDto.getTenantCode()), (Object)message);
                continue;
            }
            this.rabbitTemplate.convertAndSend("msg." + sendType + ".direct", "msg." + sendType, (Object)message);
        }
        return true;
    }
}

