/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CpRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(CpRabbitMqReceiver.class);
    @Autowired
    private MsgCpSendThirdService cpSendThirdService;
    @Autowired
    private MsgUnitySendFrameService cpUnitySendServiceImpl;

    @RabbitHandler
    @RabbitListener(queues={"#{cpQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg cp json:{}", (Object)json);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)json).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)json).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)json, MsgUnitySendDto.class);
                this.cpUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                CpSendRecordDto info = (CpSendRecordDto)JSONObject.parseObject((String)json, CpSendRecordDto.class);
                this.cpSendThirdService.sendCpTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

