/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.deploy.client.event.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.common.enums.MsgOpenInterfaceEnum;
import com.jxdinfo.hussar.msg.deploy.client.model.MsgClientApp;
import com.jxdinfo.hussar.msg.deploy.client.service.MsgClientAppService;
import com.jxdinfo.hussar.msg.event.MsgAfterDeleteAppEvent;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class MsgAfterDeleteAppEventListener
implements ApplicationListener<MsgAfterDeleteAppEvent> {
    @Autowired
    private MsgClientAppService msgClientAppService;
    @Autowired
    private ISysClientPermissionService sysClientPermissionService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private ISysResourcesService sysResourcesService;

    @HussarTransactional
    public void onApplicationEvent(MsgAfterDeleteAppEvent event) {
        Long appAccessId = (Long)event.getSource();
        List msgClientApps = this.msgClientAppService.list((Wrapper)new LambdaQueryWrapper().eq(MsgClientApp::getAppAccessId, (Object)appAccessId));
        if (HussarUtils.isNotEmpty((Object)msgClientApps)) {
            String serviceTypes = this.appAccessService.findById(((MsgClientApp)msgClientApps.get(0)).getAppAccessId().longValue()).getServiceType();
            String[] serviceTypeStrs = serviceTypes.split("[,\uff0c]");
            ArrayList<String> paths = new ArrayList<String>();
            for (String serviceType : serviceTypeStrs) {
                if (HussarUtils.equals((Object)serviceType, (Object)"mail")) {
                    paths.add(MsgOpenInterfaceEnum.MAIL_SINGLE.getValue());
                    paths.add(MsgOpenInterfaceEnum.MAIL_BATH.getValue());
                    continue;
                }
                if (HussarUtils.equals((Object)serviceType, (Object)"app_im")) {
                    paths.add(MsgOpenInterfaceEnum.APP_IM_TEXT.getValue());
                    paths.add(MsgOpenInterfaceEnum.APP_IM_ARTICLE.getValue());
                    paths.add(MsgOpenInterfaceEnum.APP_IM_IMG.getValue());
                    paths.add(MsgOpenInterfaceEnum.APP_IM_FILE.getValue());
                    continue;
                }
                paths.add(MsgOpenInterfaceEnum.getValueByKey((String)serviceType));
            }
            List resourceIds = this.sysResourcesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getResTypeId, (Object)"res_open_interface")).in(SysResources::getUrlNames, paths)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            })).stream().map(SysResources::getId).collect(Collectors.toList());
            for (MsgClientApp msgClientApp : msgClientApps) {
                this.sysClientPermissionService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysClientPermission::getClientId, (Object)msgClientApp.getClientId())).in(SysClientPermission::getPermissionId, resourceIds));
            }
            this.msgClientAppService.removeByIds((Collection)msgClientApps);
        }
    }
}

