/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.factory;

import com.jxdinfo.hussar.msg.send.service.MsgSendExecutor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgSendExecutorFactory
implements InitializingBean {
    @Autowired(required=false)
    private List<MsgSendExecutor> sendExecutor;
    private static final Map<String, MsgSendExecutor> SEND_MAP = new HashMap<String, MsgSendExecutor>();

    public void afterPropertiesSet() throws Exception {
        if (HussarUtils.isNotEmpty(this.sendExecutor)) {
            for (MsgSendExecutor sendExecutor : this.sendExecutor) {
                String sendType = sendExecutor.getSendType();
                if (!HussarUtils.isNotEmpty((Object)sendExecutor.getSendType())) continue;
                SEND_MAP.put(sendType, sendExecutor);
            }
        }
    }

    public static MsgSendExecutor getSendExecutor(String sendType) {
        MsgSendExecutor sendExecutor = SEND_MAP.get(sendType);
        if (HussarUtils.isEmpty((Object)sendExecutor)) {
            throw new HussarException(String.format("\u672a\u627e\u5230[%s]\u5bf9\u5e94\u7684\u6d88\u606f\u53d1\u9001\u5b9e\u73b0\u7c7b", sendType));
        }
        return sendExecutor;
    }

    public static List<String> getAllSendType() {
        return new ArrayList<String>(SEND_MAP.keySet());
    }
}

