/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service;

import com.jxdinfo.hussar.msg.contact.service.MsgReceiverIdExtendProvider;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgReceiverIdProviderFactory {
    @Autowired(required=false)
    private List<MsgReceiverIdExtendProvider> msgReceiverIdExtendProviders;
    private static final Map<String, MsgReceiverIdExtendProvider> RECEIVERLISTENERMAP = new HashMap<String, MsgReceiverIdExtendProvider>();

    @PostConstruct
    public void init() {
        if (HussarUtils.isNotEmpty(this.msgReceiverIdExtendProviders)) {
            for (MsgReceiverIdExtendProvider msgReceiverIdExtendProvider : this.msgReceiverIdExtendProviders) {
                if (!HussarUtils.isNotEmpty(msgReceiverIdExtendProvider.getSendTypes())) continue;
                msgReceiverIdExtendProvider.getSendTypes().forEach(sendType -> RECEIVERLISTENERMAP.put((String)sendType, msgReceiverIdExtendProvider));
            }
        }
    }

    public static MsgReceiverIdExtendProvider getMsgGetReceiverListener(String sendType) {
        MsgReceiverIdExtendProvider msgReceiverIdExtendProvider = RECEIVERLISTENERMAP.get(sendType);
        if (msgReceiverIdExtendProvider != null && msgReceiverIdExtendProvider.support()) {
            return msgReceiverIdExtendProvider;
        }
        return null;
    }

    public static boolean exitExtendProvider(String sendType) {
        return MsgReceiverIdProviderFactory.getMsgGetReceiverListener(sendType) != null;
    }
}

