/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.common.enums;

import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.EnumSet;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public enum QueueEnum {
    QUEUE_MSG_SMS("msg.sms.direct", "msg.sms", "msg.sms", "sms"),
    QUEUE_MSG_MP("msg.wx_account.direct", "msg.wx_account", "msg.wx_account", "wx_account"),
    QUEUE_MSG_APPIM("msg.app_im.direct", "msg.app_im", "msg.app_im", "app_im"),
    QUEUE_MSG_MAIL("msg.mail.direct", "msg.mail", "msg.mail", "mail"),
    QUEUE_MSG_APPPUSH("msg.app_push.direct", "msg.app_push", "msg.app_push", "app_push"),
    QUEUE_MSG_NOTICE("msg.notice.direct", "msg.notice", "msg.notice", "notice"),
    QUEUE_MSG_CP("msg.cp.direct", "msg.cp", "msg.cp", "cp"),
    QUEUE_MSG_DINGTALK("msg.dingTalk.direct", "msg.dingTalk", "msg.dingTalk", "dingTalk");

    private String exchange;
    private String name;
    private String routeKey;
    private String type;
    private String queuePrefix;
    private UnifiedMessageProperties unifiedMessageProperties;

    private QueueEnum(String exchange, String name, String routeKey, String type) {
        this.exchange = exchange;
        this.name = name;
        this.routeKey = routeKey;
        this.type = type;
    }

    public static QueueEnum getQueueEnumByType(String type) {
        for (QueueEnum queueEnum : QueueEnum.values()) {
            if (!HussarUtils.equals((Object)queueEnum.type, (Object)type)) continue;
            return queueEnum;
        }
        return null;
    }

    private void setUnifiedMessageProperties(UnifiedMessageProperties unifiedMessageProperties) {
        this.unifiedMessageProperties = unifiedMessageProperties;
        this.queuePrefix = this.unifiedMessageProperties.getQueuePrefix();
    }

    public String getExchange() {
        return this.queuePrefix + this.exchange;
    }

    public String getName() {
        return this.queuePrefix + this.name;
    }

    public String getRouteKey() {
        return this.queuePrefix + this.routeKey;
    }

    public String getType() {
        return this.type;
    }

    @Component
    public static class PropertiesServiceInjector {
        @Autowired
        protected UnifiedMessageProperties unifiedMessageProperties;

        @PostConstruct
        public void postConstruct() {
            for (QueueEnum queueEnum : EnumSet.allOf(QueueEnum.class)) {
                queueEnum.setUnifiedMessageProperties(this.unifiedMessageProperties);
            }
        }
    }
}

