/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.log.controller;

import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.log.dto.LogDownloadDto;
import com.jxdinfo.hussar.log.service.ILogDownloadService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logDownloadFront"})
@Api(tags={"\u65e5\u5fd7\u4e0b\u8f7d\u7ba1\u7406"})
public class LogDownLoadFrontController {
    private static Map<String, String> FILE_PATH = new HashMap<String, String>();
    @Resource
    private ILogDownloadService iLogDownloadService;

    @GetMapping(value={"/logTree"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5fd7\u76ee\u5f55\u6811", notes="\u83b7\u53d6\u65e5\u5fd7\u76ee\u5f55\u6811")
    @AuditLog(moduleName="\u65e5\u5fd7\u4e0b\u8f7d\u7ba1\u7406", eventDesc="\u83b7\u53d6\u65e5\u5fd7\u76ee\u5f55\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"logDownload:logTree"})
    public ApiResponse<List<JSTreeModel>> getLogTree() {
        return this.iLogDownloadService.getLogTree_new();
    }

    @GetMapping(value={"/logTable"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5fd7\u6587\u4ef6\u5217\u8868", notes="\u83b7\u53d6\u65e5\u5fd7\u6587\u4ef6\u5217\u8868")
    @AuditLog(moduleName="\u65e5\u5fd7\u4e0b\u8f7d\u7ba1\u7406", eventDesc="\u83b7\u53d6\u65e5\u5fd7\u6587\u4ef6\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"logDownload:logTable"})
    public ApiResponse<Map<String, Object>> getLogTable(@ApiParam(value="\u6240\u5c5e\u76ee\u5f55\u7684pathId") @RequestParam(value="pathId") String pathId) {
        return this.iLogDownloadService.getLogTable(pathId);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u65e5\u5fd7\u6587\u4ef6\u4e0b\u8f7d", notes="\u65e5\u5fd7\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u65e5\u5fd7\u4e0b\u8f7d\u7ba1\u7406", eventDesc="\u65e5\u5fd7\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    @CheckPermission(value={"logDownload:download"})
    public void fileDownload(@ApiParam(value="\u65e5\u5fd7\u4e0b\u8f7ddto") @RequestBody LogDownloadDto logDownloadDto, HttpServletResponse response) {
        String fileId = logDownloadDto.getFileId();
        this.iLogDownloadService.fileDownload(fileId, response);
    }
}

