/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.log.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.LoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class Log4jUtil {
    private static final Logger log = LoggerFactory.getLogger(Log4jUtil.class);
    private static PluginManager pluginManager = new PluginManager("Core");
    private static final int BUF_SIZE = 16384;
    private static String logPath;

    private Log4jUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLogPath() {
        if (logPath == null) {
            XmlConfiguration xmlConfiguration = (XmlConfiguration)LoggerContext.getContext().getConfiguration();
            ConfigurationSource configurationSource = xmlConfiguration.getConfigurationSource();
            String path = xmlConfiguration.getName();
            File f = new File(path);
            File fi = null;
            String logConfigFileName = f.getName();
            ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
            URL url = Loader.getResource((String)logConfigFileName, (ClassLoader)loader);
            InputStream is = null;
            try {
                if (FileUtils.isFile((URL)url)) {
                    fi = FileUtils.fileFromUri((URI)url.toURI());
                    is = new FileInputStream(fi);
                } else {
                    is = url.openStream();
                }
                byte[] buffer1 = null;
                try {
                    buffer1 = Log4jUtil.toByteArray(is);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    Closer.closeSilently((AutoCloseable)is);
                }
                try {
                    InputSource source = new InputSource(new ByteArrayInputStream(buffer1));
                    source.setSystemId(configurationSource.getLocation());
                    DocumentBuilder documentBuilder = Log4jUtil.newDocumentBuilder();
                    try {
                        Document document = documentBuilder.parse(source);
                        Element rootElement = document.getDocumentElement();
                        org.apache.logging.log4j.core.config.Node node = new org.apache.logging.log4j.core.config.Node();
                        Log4jUtil.constructHierarchy(node, rootElement);
                        if (logPath != null) {
                            log.debug("------================--------");
                            log.debug(logPath);
                            log.debug("------================--------");
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                catch (ParserConfigurationException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
            catch (URISyntaxException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        return logPath;
    }

    public static String getHostName() {
        return NetUtils.getLocalHostname();
    }

    protected static byte[] toByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    private static void constructHierarchy(org.apache.logging.log4j.core.config.Node node, Element element) {
        Map nodeAttr;
        Log4jUtil.processAttributes(node, element);
        StringBuilder buffer = new StringBuilder();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node w3cNode = list.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                String name = Log4jUtil.getType(child);
                PluginType type = pluginManager.getPluginType(name);
                org.apache.logging.log4j.core.config.Node childNode = new org.apache.logging.log4j.core.config.Node(node, name, type);
                Log4jUtil.constructHierarchy(childNode, child);
                continue;
            }
            if (!(w3cNode instanceof Text)) continue;
            Text data = (Text)w3cNode;
            buffer.append(data.getData());
        }
        String text = buffer.toString().trim();
        if (text.length() > 0 || !node.hasChildren() && !node.isRoot()) {
            node.setValue(text);
        }
        if (!(nodeAttr = node.getAttributes()).isEmpty() && "log.path".equalsIgnoreCase((String)nodeAttr.get("name"))) {
            logPath = node.getValue();
        }
    }

    private static String getType(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            Node w3cNode = attrs.item(i);
            if (!(w3cNode instanceof Attr) || !"type".equalsIgnoreCase((attr = (Attr)w3cNode).getName())) continue;
            String type = attr.getValue();
            attrs.removeNamedItem(attr.getName());
            return type;
        }
        return element.getTagName();
    }

    private static Map<String, String> processAttributes(org.apache.logging.log4j.core.config.Node node, Element element) {
        NamedNodeMap attrs = element.getAttributes();
        Map attributes = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            Node w3cNode = attrs.item(i);
            if (!(w3cNode instanceof Attr) || "xml:base".equals((attr = (Attr)w3cNode).getName())) continue;
            attributes.put(attr.getName(), attr.getValue());
        }
        return attributes;
    }
}

