/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.log.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.log.service.ILogDownloadService;
import com.jxdinfo.hussar.log.utils.Log4jUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogDownloadServiceImpl
implements ILogDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(LogDownloadServiceImpl.class);
    private static Map<String, String> FILE_PATH = new HashMap<String, String>();

    public ApiResponse<List<JSTreeModel>> getLogTree() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        String path = Log4jUtil.getLogPath();
        if (ToolUtil.isEmpty((Object)path)) {
            throw new BaseException("\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e\uff01");
        }
        String pathId = UUID.randomUUID().toString();
        if (!FILE_PATH.containsValue(path)) {
            FILE_PATH.put(pathId, path);
        }
        File file = new File(path);
        String rootName = file.getName();
        this.getLogDirectory(file, result);
        JSTreeModel root = new JSTreeModel();
        root.setCode(rootName);
        root.setText("\u65e5\u5fd7\u76ee\u5f55");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setPath(LogDownloadServiceImpl.getKey(FILE_PATH, path));
        result.add(root);
        return ApiResponse.success((Object)TreeModelUtils.merge(result));
    }

    public ApiResponse<Map<String, Object>> getLogTable(String pathId) {
        String directory = FILE_PATH.get(pathId);
        Page page = new Page();
        List<Map<String, Object>> list = this.getFiles(directory);
        page.setRecords(list);
        page.setTotal((long)list.size());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", page.getRecords());
        map.put("count", page.getTotal());
        return ApiResponse.success(map);
    }

    public void fileDownload(String fileId, HttpServletResponse response) {
        String filePath = FILE_PATH.get(fileId);
        File file = new File(filePath);
        String fileName = "";
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            fileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<JSTreeModel> getLogDirectory(File file, List<JSTreeModel> resultFiles) {
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return resultFiles;
        }
        for (File f : files) {
            String filePath = f.getAbsolutePath();
            String pathId = UUID.randomUUID().toString();
            if (!FILE_PATH.containsValue(filePath)) {
                if (f.isFile()) {
                    if (filePath.endsWith(".log")) {
                        FILE_PATH.put(pathId, filePath);
                    }
                } else {
                    FILE_PATH.put(pathId, filePath);
                }
            }
            if (!f.isDirectory()) continue;
            JSTreeModel node = new JSTreeModel();
            node.setCode(f.getName());
            node.setText(f.getName());
            node.setParentTypeCode(f.getParentFile().getName());
            node.setType("directory");
            node.setPath(LogDownloadServiceImpl.getKey(FILE_PATH, filePath));
            resultFiles.add(node);
            this.getLogDirectory(f, resultFiles);
        }
        return resultFiles;
    }

    public ApiResponse<List<JSTreeModel>> getLogTree_new() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        String path = Log4jUtil.getLogPath();
        if (ToolUtil.isEmpty((Object)path)) {
            throw new BaseException("\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e\uff01");
        }
        String pathId = UUID.randomUUID().toString();
        if (!FILE_PATH.containsValue(path)) {
            FILE_PATH.put(pathId, path);
        }
        File file = new File(path);
        String rootName = file.getName();
        JSTreeModel root = new JSTreeModel();
        result.add(root);
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(rootName);
        root.setText("\u65e5\u5fd7\u76ee\u5f55");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setPath(LogDownloadServiceImpl.getKey(FILE_PATH, path));
        this.getLogDirectory_new(root);
        return ApiResponse.success(result);
    }

    private JSTreeModel getLogDirectory_new(JSTreeModel resultFiles) {
        LinkedList<JSTreeModel> queue = new LinkedList<JSTreeModel>();
        queue.offer(resultFiles);
        while (!queue.isEmpty()) {
            JSTreeModel poll = (JSTreeModel)queue.poll();
            String path = FILE_PATH.get(poll.getPath());
            File file = new File(path);
            File[] files = file.listFiles();
            if (!ToolUtil.isNotEmpty((Object)files)) continue;
            ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
            poll.setChildrenList(list);
            for (File temp : files) {
                String filePath = temp.getAbsolutePath();
                String pathId = UUID.randomUUID().toString();
                if (!FILE_PATH.containsValue(filePath)) {
                    FILE_PATH.put(pathId, filePath);
                }
                if (!temp.isDirectory()) continue;
                JSTreeModel node = new JSTreeModel();
                node.setId(Long.valueOf(Long.parseLong(String.valueOf(Math.random()).substring(2))));
                node.setCode(temp.getName());
                node.setText(temp.getName());
                node.setParentTypeCode(temp.getParentFile().getName());
                node.setType("directory");
                node.setPath(LogDownloadServiceImpl.getKey(FILE_PATH, filePath));
                list.add(node);
                queue.offer(node);
            }
        }
        return resultFiles;
    }

    private List<Map<String, Object>> getFiles(String directory) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        File file = new File(directory);
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return result;
        }
        for (File f : files) {
            if (!f.isFile() || !file.getPath().equals(f.getParent())) continue;
            String filePath = f.getAbsolutePath();
            if (!FILE_PATH.containsValue(filePath)) {
                String uuid = UUID.randomUUID().toString();
                FILE_PATH.put(uuid, filePath);
            }
            HashMap<String, Object> node = new HashMap<String, Object>(3);
            if (f.length() <= 0L) continue;
            node.put("fileId", LogDownloadServiceImpl.getKey(FILE_PATH, filePath));
            node.put("fileName", f.getName());
            node.put("fileSize", f.length() / 1024L);
            node.put("fileLastEditTime", this.formatDate(f.lastModified()));
            result.add(node);
        }
        return result;
    }

    private String formatDate(long timestamp) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        date.setTime(timestamp);
        return DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private static String getKey(Map<String, String> map, String value) {
        String key = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            key = entry.getKey();
        }
        return key;
    }
}

