/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.leavemessage.util;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.organ.model.JSTreeModelPlus;
import com.jxdinfo.hussar.leavemessage.manager.QueryActMessageManager;
import com.jxdinfo.hussar.leavemessage.model.SysActMessage;
import com.jxdinfo.hussar.leavemessage.qo.MessagePageQo;
import com.jxdinfo.hussar.leavemessage.qo.OrganQo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final String SENDING = "sending";
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);

    public static LambdaQueryWrapper<SysActMessage> listQueryWrapper(MessagePageQo qo, String column) {
        SecurityUser user;
        LambdaQueryWrapper eq = ((QueryWrapper)new QueryWrapper().orderByDesc((Object)"CREATE_TIME")).lambda();
        if (ToolUtil.isNotEmpty((Object)qo) && ToolUtil.isNotEmpty((Object)qo.getView())) {
            eq.ne(SysActMessage::getFormView, (Object)1);
        }
        if ((user = BaseSecurityUtil.getUser()) != null) {
            if (SENDING.equals(column)) {
                eq.eq(SysActMessage::getSendingUser, (Object)user.getId());
            } else {
                eq.eq(SysActMessage::getReceivingUser, (Object)user.getId());
            }
        }
        if (ToolUtil.isNotEmpty((Object)qo.getRelatedParam())) {
            return (LambdaQueryWrapper)eq.eq(SysActMessage::getRelatedParam, (Object)qo.getRelatedParam());
        }
        return (LambdaQueryWrapper)eq.eq(SysActMessage::getFormId, (Object)qo.getFormId());
    }

    public static Map<String, Object> getOrganEmployeeList(OrganQo qo, QueryActMessageManager sysActMessageService, Encrypt encrypt) {
        SecurityUser user;
        int type;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        Page page = null;
        int n = type = qo.getType() != null ? qo.getType() : 2;
        if (type == 3) {
            page = new Page((long)qo.getCurrent(), (long)qo.getSize());
        }
        if ((user = BaseSecurityUtil.getUser()) == null) {
            result.put("code", "500");
            return result;
        }
        List<String> receiveNames = null;
        String connName = "master";
        if (type == 1) {
            HussarTenantDefinition tenant;
            Long userId = user.getId();
            String label = qo.getLabel();
            if ("platformLevel".equals(label)) {
                connName = "master";
            } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
                connName = tenant.getConnName();
            }
            receiveNames = sysActMessageService.receiveName(userId);
            if (receiveNames == null || receiveNames.isEmpty()) {
                result.put("code", "0");
                result.put("data", new ArrayList());
                return result;
            }
        }
        List<Object> jsTreeModels = sysActMessageService.organEmployeeList((Page<JSTreeModelPlus>)page, qo.getQueryText(), null);
        if (receiveNames != null && !receiveNames.isEmpty() && !jsTreeModels.isEmpty()) {
            String receiveNameStr = StringUtils.join((Object[])receiveNames.toArray(), (char)',');
            jsTreeModels = jsTreeModels.stream().filter(node -> receiveNameStr.contains(node.getUserId())).collect(Collectors.toList());
        }
        for (JSTreeModelPlus jsTreeModelPlus : jsTreeModels) {
            if (!HussarUtils.isNotEmpty((Object)jsTreeModelPlus.getMobile())) continue;
            try {
                jsTreeModelPlus.setMobile(encrypt.decrypt(jsTreeModelPlus.getMobile()));
            }
            catch (Exception exception) {}
        }
        result.put("code", "0");
        result.put("data", jsTreeModels);
        if (page != null) {
            result.put("count", page.getTotal());
        }
        return result;
    }
}

