/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.leavemessage.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.leavemessage.dao.SysLeaveMessageMapper;
import com.jxdinfo.hussar.leavemessage.model.SysLeaveMessages;
import com.jxdinfo.hussar.leavemessage.service.IHussarBaseLeaveMessagesService;
import com.jxdinfo.hussar.leavemessage.service.ISysLeaveMessageService;
import com.jxdinfo.hussar.leavemessage.vo.HussarQueryPageVo;
import com.jxdinfo.hussar.leavemessage.vo.QueryMessageVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.leavemessage.service.impl.hussarBaseLeaveMessageServiceImpl")
@HussarTokenDs
public class HussarBaseLeaveMessageServiceImpl
implements IHussarBaseLeaveMessagesService {
    @Autowired
    private SysLeaveMessageMapper leaveMessagesMapper;
    @Autowired
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysLeaveMessageService leaveMessageService;

    public QueryMessageVo queryMessages() {
        Page page = new Page();
        Long userId = BaseSecurityUtil.getUser().getId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("messageStatus", "0");
        String days = this.sysBaseConfigService.getSysBaseConfigDto("leave_message_days").getConfigValue();
        LocalDateTime date = LocalDateTime.now().minusDays(Long.parseLong(days));
        map.put("date", date);
        List<SysLeaveMessages> leaveMessages = this.leaveMessagesMapper.hussarQueryPage(page, map);
        QueryMessageVo queryMessageVo = new QueryMessageVo();
        queryMessageVo.setCount(page.getTotal());
        queryMessageVo.setData(leaveMessages);
        return queryMessageVo;
    }

    public HussarQueryPageVo hussarQueryPage(PageInfo pageInfo, String sendUserName, String startDate, String endDate) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        AssertUtil.isNotNull((Object)securityUser, (String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDateTime startDateTime = null;
        LocalDateTime endDateTime = null;
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            startDateTime = LocalDateTime.parse(startDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            endDateTime = LocalDateTime.parse(endDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", securityUser.getId());
        map.put("sendUserName", SqlQueryUtil.transferSpecialChar((String)sendUserName));
        map.put("startTime", startDateTime);
        map.put("endTime", endDateTime);
        String days = this.sysBaseConfigService.getSysBaseConfigDto("leave_message_days").getConfigValue();
        LocalDateTime date = LocalDateTime.now().minusDays(Long.parseLong(days));
        map.put("date", date);
        List<SysLeaveMessages> result = this.leaveMessagesMapper.hussarQueryPage(page, map);
        page.setRecords(result);
        HussarQueryPageVo hussarQueryPageVo = new HussarQueryPageVo();
        hussarQueryPageVo.setPageData(page);
        hussarQueryPageVo.setDays(days);
        return hussarQueryPageVo;
    }

    @HussarTransactional
    public boolean del(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            this.leaveMessageService.removeByIds(ids);
        }
        return true;
    }

    public SysLeaveMessages formQuery(Long id) {
        return (SysLeaveMessages)this.leaveMessageService.getById((Serializable)id);
    }

    @HussarTransactional
    public boolean insert(SysLeaveMessages leaveMessages) {
        if (HussarUtils.isEmpty((Object)leaveMessages.getReceiveUserId())) {
            throw new BaseException("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
        }
        leaveMessages.setMessageMode("0");
        if (HussarUtils.isEmpty((Object)leaveMessages.getMessageUrl()) && HussarUtils.isEmpty((Object)leaveMessages.getProcessDefinitionKey())) {
            leaveMessages.setMessageMode("1");
        }
        leaveMessages.setMessageStatus("0");
        leaveMessages.setCreateTime(LocalDateTime.now());
        this.leaveMessageService.save((Object)leaveMessages);
        return true;
    }

    @HussarTransactional
    public boolean updateSatus(List<Long> ids) {
        ArrayList<SysLeaveMessages> updateList = new ArrayList<SysLeaveMessages>();
        if (null != ids && !ids.isEmpty()) {
            for (Long id : ids) {
                SysLeaveMessages messages = new SysLeaveMessages();
                messages.setId(id);
                messages.setMessageStatus("1");
                messages.setMessageTime(new Date());
                updateList.add(messages);
            }
            this.leaveMessageService.updateBatchById(updateList);
        }
        return true;
    }
}

