/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.leavemessage.controller;

import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.leavemessage.dto.QueryLeaveMessageDto;
import com.jxdinfo.hussar.leavemessage.model.SysLeaveMessages;
import com.jxdinfo.hussar.leavemessage.service.IHussarBaseLeaveMessagesService;
import com.jxdinfo.hussar.leavemessage.vo.HussarQueryPageVo;
import com.jxdinfo.hussar.leavemessage.vo.QueryMessageVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/leaveMessages"})
public class HussarBaseLeaveMessagesController {
    @Resource
    private IHussarBaseLeaveMessagesService hussarBaseLeaveMessagesService;

    @GetMapping(value={"/queryMessages"})
    public ApiResponse<QueryMessageVo> queryMessages() {
        return ApiResponse.success((Object)this.hussarBaseLeaveMessagesService.queryMessages());
    }

    @GetMapping(value={"/hussarQueryPage"})
    @AuditLog(moduleName="\u7559\u8a00\u6d88\u606f\u8868\u5217\u8868\u67e5\u8be2", eventDesc="\u7559\u8a00\u6d88\u606f\u8868\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<HussarQueryPageVo> hussarQueryPage(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7559\u8a00\u6d88\u606f\u5217\u8868dto") QueryLeaveMessageDto queryLeaveMessageDto) {
        return ApiResponse.success((Object)this.hussarBaseLeaveMessagesService.hussarQueryPage(pageInfo, queryLeaveMessageDto.getSendUserName(), queryLeaveMessageDto.getStartDate(), queryLeaveMessageDto.getEndDate()));
    }

    @PostMapping(value={"/del"})
    public ApiResponse<Boolean> del(@RequestParam(value="ids") Long[] ids) {
        return ApiResponse.success((Object)this.hussarBaseLeaveMessagesService.del(Arrays.asList(ids)));
    }

    @GetMapping(value={"/formQuery"})
    public ApiResponse<SysLeaveMessages> formQuery(@RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.hussarBaseLeaveMessagesService.formQuery(id));
    }

    @PostMapping(value={"/insert"})
    @AuditLog(moduleName="\u65b0\u589e\u7559\u8a00\u6d88\u606f", eventDesc="\u65b0\u589e\u7559\u8a00\u6d88\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> insert(@RequestBody SysLeaveMessages sysLeaveMessages) {
        return ApiResponse.success((Object)this.hussarBaseLeaveMessagesService.insert(sysLeaveMessages));
    }

    @PostMapping(value={"/updateSatus"})
    public ApiResponse<Boolean> updateSatus(@RequestParam(value="ids") Long[] ids) {
        return ApiResponse.success((Object)this.hussarBaseLeaveMessagesService.updateSatus(Arrays.asList(ids)));
    }
}

