/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.leavemessage.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.organ.model.JSTreeModelPlus;
import com.jxdinfo.hussar.leavemessage.dao.SysActMessageMapper;
import com.jxdinfo.hussar.leavemessage.manager.QueryActMessageManager;
import com.jxdinfo.hussar.leavemessage.model.SysActMessage;
import com.jxdinfo.hussar.leavemessage.qo.MessagePageQo;
import com.jxdinfo.hussar.leavemessage.qo.OrganQo;
import com.jxdinfo.hussar.leavemessage.service.IHussarBaseActMessageService;
import com.jxdinfo.hussar.leavemessage.service.ISysActMessageService;
import com.jxdinfo.hussar.leavemessage.util.MessageUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.leavemessage.service.impl.hussarBaseActMessageServiceImpl")
@HussarTokenDs
public class HussarBaseActMessageServiceImpl
implements IHussarBaseActMessageService {
    @Autowired
    private SysActMessageMapper messageMapper;
    @Resource
    private ISysActMessageService sysActMessageService;
    @Resource
    private QueryActMessageManager queryActMessageManager;
    @Autowired
    private Encrypt encrypt;

    public Map<String, Object> getSendMessagePage(MessagePageQo qo) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        LambdaQueryWrapper<SysActMessage> queryWrapper = MessageUtil.listQueryWrapper(qo, "sending");
        if (queryWrapper == null) {
            throw new BaseException();
        }
        Page page = new Page();
        page.setCurrent((long)qo.getCurrent());
        page.setSize((long)qo.getSize());
        Page sysActMessagePage = (Page)this.messageMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        result.put("count", sysActMessagePage.getTotal());
        result.put("data", sysActMessagePage.getRecords());
        result.put("code", ResultCode.SUCCESS.getCode());
        return result;
    }

    public boolean formSaveBatch(Map<String, Object> map) {
        List sysActMessages = JSON.parseArray((String)JSON.toJSONString((Object)map.get("messages")), SysActMessage.class);
        if (ToolUtil.isEmpty((Object)map.get("update"))) {
            SecurityUser user = BaseSecurityUtil.getUser();
            for (SysActMessage sysActMessage : sysActMessages) {
                sysActMessage.setSendingUser(user.getId());
                sysActMessage.setSendingUName(user.getName());
                sysActMessage.setCreateTime(LocalDateTime.now());
                if (ToolUtil.isNotEmpty((Object)sysActMessage.getWorkItemId())) {
                    sysActMessage.setWorkItemName(this.queryActMessageManager.workNameByTaskId(sysActMessage.getWorkItemId()));
                }
                sysActMessage.setFormView(Integer.valueOf(0));
            }
        }
        return this.sysActMessageService.saveOrUpdateBatch((Collection)sysActMessages);
    }

    public Map<String, Object> getReceivingMessage(MessagePageQo qo) {
        long count;
        List list;
        Page page;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        LambdaQueryWrapper<SysActMessage> queryWrapper = MessageUtil.listQueryWrapper(qo, "receiving");
        if (queryWrapper == null) {
            throw new BaseException();
        }
        Page page2 = page = ToolUtil.isNotEmpty((Object)qo.getView()) ? null : new Page((long)qo.getCurrent(), (long)qo.getSize());
        if (page != null) {
            Page sysActMessagePage = (Page)this.messageMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            list = sysActMessagePage.getRecords();
            count = sysActMessagePage.getTotal();
        } else {
            list = this.messageMapper.selectList((Wrapper)queryWrapper.select(new SFunction[]{SysActMessage::getId}));
            count = list.size();
        }
        result.put("count", count);
        result.put("data", list);
        result.put("code", "0");
        return result;
    }

    public Map<String, Object> organEmployeeList(OrganQo qo) {
        return MessageUtil.getOrganEmployeeList(qo, this.queryActMessageManager, this.encrypt);
    }

    public boolean removeMessage(String ids) {
        Set idSet = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        return this.sysActMessageService.removeByIds(idSet);
    }

    public List<JSTreeModelPlus> organTree() {
        List<JSTreeModelPlus> list = this.messageMapper.organTree();
        ArrayList<JSTreeModelPlus> treeList = new ArrayList<JSTreeModelPlus>();
        for (JSTreeModelPlus tree : list) {
            if (!Constants.ROOT_NODE_ID.equals(tree.getParent())) continue;
            treeList.add(HussarBaseActMessageServiceImpl.findChildren(tree, list));
        }
        return treeList;
    }

    public List<JSTreeModelPlus> organListByStruId(Long struId) {
        String connName = "master";
        HussarTenantDefinition tenant = HussarContextHolder.getHussarTenant();
        if (HussarUtils.isNotEmpty((Object)tenant)) {
            connName = tenant.getConnName();
        }
        return this.queryActMessageManager.organEmployeeList(null, null, struId);
    }

    public Page<JSTreeModelPlus> queryOrganList(Map<String, Object> map) {
        HussarTenantDefinition tenant;
        int pageNo = map.get("page") == null ? 1 : Integer.parseInt(map.get("page").toString());
        int limit = map.get("limit") == null ? 20 : Integer.parseInt(map.get("limit").toString());
        Long struId = map.get("struId") == null ? null : Long.valueOf(Long.parseLong(map.get("struId").toString()));
        String text = map.get("text") == null ? null : map.get("text").toString();
        String label = map.get("label") == null ? "platformLevel" : map.get("label").toString();
        Page page = new Page((long)pageNo, (long)limit);
        String connName = "master";
        if ("platformLevel".equals(label)) {
            connName = "master";
        } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
            connName = tenant.getConnName();
        }
        List<JSTreeModelPlus> list = this.queryActMessageManager.organEmployeeList((Page<JSTreeModelPlus>)page, text, struId);
        for (JSTreeModelPlus jsTreeModelPlus : list) {
            if (!HussarUtils.isNotEmpty((Object)jsTreeModelPlus.getMobile())) continue;
            jsTreeModelPlus.setMobile(this.decrypt(jsTreeModelPlus.getMobile()));
        }
        page.setRecords(list);
        return page;
    }

    private String decrypt(String str) {
        try {
            return this.encrypt.decrypt(str);
        }
        catch (Exception e) {
            return str;
        }
    }

    private static JSTreeModelPlus findChildren(JSTreeModelPlus tree, List<JSTreeModelPlus> list) {
        for (JSTreeModelPlus node : list) {
            if (!tree.getId().equals(node.getParent()) || tree.getChildrenList() == null) continue;
            tree.getChildrenList().add(HussarBaseActMessageServiceImpl.findChildren(node, list));
        }
        return tree;
    }
}

