/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMgtMapper;
import com.jxdinfo.hussar.lang.dto.SysMultiLangMgtDto;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtBoService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.lang.vo.LangQueryVo;
import com.jxdinfo.hussar.lang.vo.SysMultiLangMgtUpdatePackVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.lang.service.impl.sysMultiLangMgtBoServiceImpl")
public class SysMultiLangMgtBoServiceImpl
implements ISysMultiLangMgtBoService {
    @Resource
    private ISysMultiLangMgtService sysMultiLangMgtService;
    @Resource
    private SysMultiLangMgtMapper sysMultiLangMgtMapper;

    public ApiResponse<Map<String, Object>> getTextByLangKey(String langKey) {
        return this.sysMultiLangMgtService.getTextByLangKey(langKey);
    }

    public List<SysMultiLangMgt> listByLangTextAndLang(String langText, String langCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLang, (Object)langCode);
        queryWrapper.like(SysMultiLangMgt::getLangText, (Object)langText);
        List list = this.sysMultiLangMgtMapper.selectList((Wrapper)queryWrapper);
        List<Object> result = new ArrayList<SysMultiLangMgt>();
        if (HussarUtils.isNotEmpty((Object)langText)) {
            result = list.stream().filter(s -> langText.equals(s.getLangText())).collect(Collectors.toList());
        }
        return result;
    }

    public SysMultiLangMgt getOneByLangKeyAndLangCode(String langKey, String langCode) {
        LambdaQueryWrapper sysMultiLangMgtLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysMultiLangMgtLambdaQueryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey)).eq(SysMultiLangMgt::getLang, (Object)langCode);
        return (SysMultiLangMgt)this.sysMultiLangMgtService.getOne((Wrapper)sysMultiLangMgtLambdaQueryWrapper);
    }

    public List<SysMultiLangMgt> listByTypeAndLangCode(String type, String langCode) {
        LambdaQueryWrapper sysMultiLangMgtLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysMultiLangMgtLambdaQueryWrapper.eq(SysMultiLangMgt::getType, (Object)type)).eq(SysMultiLangMgt::getLang, (Object)langCode);
        return this.sysMultiLangMgtService.list((Wrapper)sysMultiLangMgtLambdaQueryWrapper);
    }

    public ApiResponse<Map<String, Object>> add(String langKey) {
        return this.sysMultiLangMgtService.add(langKey);
    }

    public ApiResponse<Map<String, Object>> update(SysMultiLangMgtDto sysMultiLangMgtDto) {
        return this.sysMultiLangMgtService.update(sysMultiLangMgtDto);
    }

    public ApiResponse<LangQueryVo> queryList(Long appId, String langText, int pageIndex, int pageSize, String type) {
        return this.sysMultiLangMgtService.queryList(appId, langText, pageIndex, pageSize, type);
    }

    public ApiResponse<Map<String, String>> getTextListByLang(String lang) {
        return this.sysMultiLangMgtService.getTextListByLang(lang);
    }

    public ApiResponse<SysMultiLangMgtUpdatePackVo> getUpdateLangPack(String lastTime, String locale) {
        return this.sysMultiLangMgtService.getUpdateLangPack(lastTime, locale);
    }
}

