/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMapper;
import com.jxdinfo.hussar.lang.dto.SysMultiLangDto;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.service.ISysMultiLangService;
import com.jxdinfo.hussar.lang.service.impl.LangAsync;
import com.jxdinfo.hussar.lang.vo.SysMultiLangVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.lang.service.impl.SysMultiLangImpl")
public class SysMultiLangImpl
extends HussarServiceImpl<SysMultiLangMapper, SysMultiLang>
implements ISysMultiLangService {
    @Resource
    LangAsync langAsync;
    private static final int DEFAULT = 1;
    private static final int NO_DEFAULT = 0;
    private static final int SHOW = 1;
    private static final int NO_SHOW = 0;

    public SysMultiLangVo getLang(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLang::getIsShow, (Object)1);
        List sysMultiLangs = ((SysMultiLangMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        TranslateUtil.translate((List)sysMultiLangs, SysMultiLang::getLangKey, SysMultiLang::setLang);
        SysMultiLangVo sysMultiLangVo = new SysMultiLangVo();
        if (HussarUtils.isNotEmpty((Object)sysMultiLangs)) {
            sysMultiLangVo.setFirstOpen(false);
        }
        sysMultiLangVo.setEnabled(TranslateUtil.getIsEnable());
        sysMultiLangVo.setSysMultiLangs(sysMultiLangs);
        return sysMultiLangVo;
    }

    public SysMultiLangVo getAllLangList(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List sysMultiLangs = ((SysMultiLangMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        TranslateUtil.translate((List)sysMultiLangs, SysMultiLang::getLangKey, SysMultiLang::setLang);
        SysMultiLangVo sysMultiLangVo = new SysMultiLangVo();
        sysMultiLangVo.setSysMultiLangs(sysMultiLangs);
        sysMultiLangVo.setEnabled(TranslateUtil.getIsEnable());
        return sysMultiLangVo;
    }

    @HussarTransactional
    public SysMultiLangVo addLang(SysMultiLangDto sysMultiLangDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLang::getLangCode, (Object)sysMultiLangDto.getLangCode());
        SysMultiLang one = (SysMultiLang)this.getOne((Wrapper)queryWrapper);
        one.setIsShow(1);
        LocalDateTime now = LocalDateTime.now();
        one.setAddTime(now);
        this.updateById((BaseEntity)one);
        SysMultiLangVo res = this.getLang(null);
        HussarCacheUtil.evict((String)"lang_list", (Object)"lang_list");
        HussarCacheUtil.put((String)"lang_list", (Object)"lang_list", (Object)res.getSysMultiLangs());
        return res;
    }

    @HussarTransactional
    public SysMultiLangVo setDefaultLang(SysMultiLangDto sysMultiLangDto) {
        List sysMultiLangs = sysMultiLangDto.getSysMultiLangs();
        this.updateBatchById(sysMultiLangs);
        return this.getLang(null);
    }

    @HussarTransactional
    public SysMultiLangVo delLang(SysMultiLang sysMultiLang) {
        if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
            if (sysMultiLang.getIsDefault() == 1) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysMultiLang::getLang, (Object)LangEnum.ZH_CN.getLangLabel());
                SysMultiLang one = (SysMultiLang)this.getOne((Wrapper)queryWrapper);
                one.setIsDefault(1);
                this.updateById((BaseEntity)one);
            }
            SysMultiLang lang = (SysMultiLang)this.getById(sysMultiLang.getLangId());
            lang.setIsDefault(0);
            lang.setIsShow(0);
            this.updateById((BaseEntity)lang);
            SysMultiLangVo res = this.getLang(null);
            HussarCacheUtil.evict((String)"lang_list", (Object)"lang_list");
            HussarCacheUtil.put((String)"lang_list", (Object)"lang_list", (Object)res.getSysMultiLangs());
            return res;
        }
        throw new BaseException("\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a");
    }

    public SysMultiLang getDefaultLang() {
        LambdaQueryWrapper sysMultiLangLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMultiLangLambdaQueryWrapper.eq(SysMultiLang::getIsDefault, (Object)1);
        return (SysMultiLang)this.getOne((Wrapper)sysMultiLangLambdaQueryWrapper);
    }
}

