/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMgtMapper;
import com.jxdinfo.hussar.lang.dto.SysBatchMultiLangMgtDto;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysBatchLangTranslateService;
import com.jxdinfo.hussar.lang.service.impl.LangAsync;
import com.jxdinfo.hussar.lang.service.impl.SysBatchLangImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.lang.service.impl.SysBatchLangTranslateImpl")
public class SysBatchLangTranslateImpl
extends HussarServiceImpl<SysMultiLangMgtMapper, SysMultiLangMgt>
implements ISysBatchLangTranslateService {
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private SysBatchLangImpl sysBatchLangImpl;
    @Resource
    private LangAsync langAsync;

    public Map<String, Object> getLangTextByListLangKey(SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        if (TranslateUtil.getIsEnable()) {
            if (HussarUtils.isEmpty((Object)sysBatchMultiLangMgtDto)) {
                return map;
            }
            String langCode = sysBatchMultiLangMgtDto.getLangCode();
            List langKeys = sysBatchMultiLangMgtDto.getLangKeys().stream().filter(s -> HussarUtils.isNotEmpty((Object)s)).collect(Collectors.toList());
            if (HussarUtils.isEmpty((Object)langCode) || HussarUtils.isEmpty(langKeys)) {
                return map;
            }
            ArrayList<String> langList = new ArrayList<String>();
            this.langAsync.getLangs(langList);
            CountDownLatch countDownLatch = new CountDownLatch(langKeys.size());
            Executor executor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            String connName = HussarContextHolder.getConnName();
            String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
            ServletRequestAttributes newServletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)tenantCode);
            for (String langKey : langKeys) {
                if (executor == null) continue;
                executor.execute(() -> {
                    HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                    RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
                    try {
                        Map langMap = (Map)HussarCacheUtil.get((String)"lang_text", (Object)langKey);
                        if (langMap != null) {
                            if (!langMap.containsKey(LANG_TEXT) || HussarUtils.isEmpty(langMap.get(LANG_TEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANG_TEXT)).get(langCode))) {
                                map.put(langKey, "");
                            }
                            map.put(langKey, ((Map)langMap.get(LANG_TEXT)).get(langCode));
                        } else {
                            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
                            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                            queryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey);
                            List sysMultiLangMgts = this.sysBatchLangImpl.list((Wrapper)queryWrapper);
                            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgts)) {
                                cacheMap.put(LANG_KEY, langKey);
                                HashMap<String, String> langTextMap = new HashMap<String, String>();
                                for (SysMultiLangMgt sysMultiLangMgt : sysMultiLangMgts) {
                                    String lang2 = sysMultiLangMgt.getLang();
                                    if (!HussarUtils.isNotEmpty((Object)lang2) || !langList.contains(lang2)) continue;
                                    langTextMap.put(sysMultiLangMgt.getLang(), sysMultiLangMgt.getLangText());
                                }
                                for (int i = 0; i < langList.size(); ++i) {
                                    if (langTextMap.containsKey(langList.get(i))) continue;
                                    langTextMap.put((String)langList.get(i), "");
                                }
                                Map sortMap = TranslateUtil.sortLangText(langTextMap, (List)langList);
                                cacheMap.put(LANG_TEXT, sortMap);
                                HussarCacheUtil.put((String)"lang_text", (Object)langKey, cacheMap);
                                List collect = sysMultiLangMgts.stream().filter(lang -> langCode.equals(lang.getLang())).collect(Collectors.toList());
                                if (HussarUtils.isNotEmpty(collect)) {
                                    map.put(langKey, ((SysMultiLangMgt)collect.get(0)).getLangText());
                                } else {
                                    map.put(langKey, "");
                                }
                            } else {
                                map.put(langKey, "");
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }
}

