/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMapper;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMgtMapper;
import com.jxdinfo.hussar.lang.dto.SysMultiLangMgtDto;
import com.jxdinfo.hussar.lang.dto.SysMultiLangMgtRecDto;
import com.jxdinfo.hussar.lang.model.SysLangTask;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysLangTaskService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.lang.service.impl.LangAsync;
import com.jxdinfo.hussar.lang.vo.LangImportVo;
import com.jxdinfo.hussar.lang.vo.LangQueryVo;
import com.jxdinfo.hussar.lang.vo.LangQueryVoNoPage;
import com.jxdinfo.hussar.lang.vo.QueryVo;
import com.jxdinfo.hussar.lang.vo.SysMultiLangMgtUpdatePackVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.lang.service.impl.SysMultiLangMgtImpl")
public class SysMultiLangMgtImpl
extends HussarServiceImpl<SysMultiLangMgtMapper, SysMultiLangMgt>
implements ISysMultiLangMgtService {
    private static Logger logger = LoggerFactory.getLogger(SysMultiLangMgtImpl.class);
    @Resource
    private ISysLangTaskService sysLangTaskService;
    @Resource
    private LangAsync langAsync;
    @Resource
    private SysMultiLangMgtMapper sysMultiLangMgtMapper;
    @Resource
    private SysMultiLangMapper sysMultiLangMapper;
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    public static final String CUSTOM_LANG = "custom";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    public static final String SYSTEM_LANG = "system";
    private static final int SHOW = 1;
    @Autowired
    private SeqBuilder seqBuilder;

    private String generateId() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    @HussarTransactional
    public ApiResponse<Map<String, Object>> add(String langKey) {
        if (langKey == null || "".equalsIgnoreCase(langKey)) {
            langKey = this.generateLangKey();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(LANG_KEY, langKey);
        HashMap<String, String> langTextMap = new HashMap<String, String>();
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        ArrayList<SysMultiLangMgt> sysMultiLangMgtList = new ArrayList<SysMultiLangMgt>();
        for (String lang : langList) {
            SysMultiLangMgt sysMultiLangMgt = new SysMultiLangMgt();
            sysMultiLangMgt.setLangKey(langKey);
            sysMultiLangMgt.setLang(lang);
            sysMultiLangMgt.setLangText("");
            sysMultiLangMgt.setType(CUSTOM_LANG);
            sysMultiLangMgtList.add(sysMultiLangMgt);
            langTextMap.put(lang, "");
        }
        this.saveBatch(sysMultiLangMgtList);
        String dataSourceKey = HussarContextHolder.getConnName();
        this.langAsync.updateLangTime(sysMultiLangMgtList, dataSourceKey);
        Map sortMap = TranslateUtil.sortLangText(langTextMap, langList);
        map.put(LANG_TEXT, sortMap);
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.langAsync.creatorCachePrefix())) {
            suffix = this.langAsync.creatorCachePrefix();
        }
        HussarCacheUtil.put((String)"lang_text", (Object)(":" + suffix + ":" + langKey), map);
        return ApiResponse.success(map);
    }

    @HussarTransactional
    public ApiResponse<Map<String, Object>> update(SysMultiLangMgtDto sysMultiLangMgtDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String langKey = sysMultiLangMgtDto.getLangKey();
            String lang = sysMultiLangMgtDto.getLang();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey)).eq(SysMultiLangMgt::getLang, (Object)lang);
            SysMultiLangMgt multiLangMgt = (SysMultiLangMgt)this.getOne((Wrapper)updateWrapper);
            if (HussarUtils.isNotEmpty((Object)multiLangMgt)) {
                multiLangMgt.setLangText(sysMultiLangMgtDto.getLangText());
                this.updateById((BaseEntity)multiLangMgt);
            } else {
                this.save((BaseEntity)sysMultiLangMgtDto);
            }
            String dataSourceKey = HussarContextHolder.getConnName();
            this.langAsync.updateLangTime(sysMultiLangMgtDto, dataSourceKey);
            this.saveOrUpdateCache(langKey);
            this.getLangTextByLangKey(langKey, map);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u4fee\u6539\u8bed\u8a00\u5305\u5931\u8d25");
        }
        return ApiResponse.success(map);
    }

    private void getLangTextByLangKey(String langKey, Map<String, Object> map) {
        Map catchMap;
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.langAsync.creatorCachePrefix())) {
            suffix = this.langAsync.creatorCachePrefix();
        }
        if ((catchMap = (Map)HussarCacheUtil.get((String)"lang_text", (Object)(":" + suffix + ":" + langKey))) != null) {
            map.put(LANG_KEY, langKey);
            HashMap langText = (HashMap)catchMap.get(LANG_TEXT);
            for (int i = 0; i < langList.size(); ++i) {
                if (langText.containsKey(langList.get(i))) continue;
                langText.put(langList.get(i), "");
            }
            map.put(LANG_TEXT, langText);
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey);
            List sysMultiLangMgts = ((SysMultiLangMgtMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgts)) {
                map.put(LANG_KEY, langKey);
                HashMap<String, String> langTextMap = new HashMap<String, String>();
                for (SysMultiLangMgt sysMultiLangMgt : sysMultiLangMgts) {
                    String lang = sysMultiLangMgt.getLang();
                    if (!HussarUtils.isNotEmpty((Object)lang) || !langList.contains(lang)) continue;
                    langTextMap.put(sysMultiLangMgt.getLang(), sysMultiLangMgt.getLangText());
                }
                for (int i = 0; i < langList.size(); ++i) {
                    if (langTextMap.containsKey(langList.get(i))) continue;
                    langTextMap.put((String)langList.get(i), "");
                }
                Map sortMap = TranslateUtil.sortLangText(langTextMap, langList);
                map.put(LANG_TEXT, sortMap);
                HussarCacheUtil.put((String)"lang_text", (Object)(":" + suffix + ":" + langKey), map);
            } else {
                map.put(LANG_KEY, "");
                map.put(LANG_TEXT, new HashMap());
            }
        }
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteByKey(String langKey) {
        if (HussarUtils.isEmpty((Object)langKey)) {
            throw new BaseException("\u5220\u9664\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (langKey.contains(",")) {
            String[] langKeys = langKey.split(",");
            keys.addAll(Arrays.asList(langKeys));
        } else {
            keys.add(langKey);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMultiLangMgt::getLangKey, keys);
        this.remove((Wrapper)queryWrapper);
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.langAsync.creatorCachePrefix())) {
            suffix = this.langAsync.creatorCachePrefix();
        }
        for (int i = 0; i < keys.size(); ++i) {
            HussarCacheUtil.evict((String)"lang_text", (Object)(":" + suffix + ":" + (String)keys.get(i)));
        }
        return ApiResponse.success((Object)true, (String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<LangQueryVo> queryList(Long appId, String langText, int pageIndex, int pageSize, String type) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        page.setSearchCount(false);
        Long total = this.sysMultiLangMgtMapper.queryListCount(appId, langText, type);
        List<QueryVo> records = this.sysMultiLangMgtMapper.queryList(appId, langText, page, type);
        page.setTotal(total.longValue());
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList maps = new ArrayList();
        for (QueryVo queryVo : records) {
            String key = queryVo.getLangKey();
            if (keys.contains(key)) continue;
            keys.add(key);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put(LANG_KEY, key);
            map2.put(LANG_TEXT, new HashMap());
            maps.add(map2);
        }
        maps.forEach(map -> {
            Object object = map.get(LANG_KEY);
            String langKey = String.valueOf(object);
            this.getLangTextByLangKey(langKey, (Map<String, Object>)map);
        });
        LangQueryVo langQueryVo = new LangQueryVo();
        langQueryVo.setContent(maps);
        langQueryVo.setTotal(Long.valueOf(page.getTotal()));
        langQueryVo.setPageIndex(pageIndex);
        return ApiResponse.success((Object)langQueryVo, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public ApiResponse<Map<String, String>> getTextListByLang(String lang) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLang, (Object)lang);
        List sysMultiLangMgts = ((SysMultiLangMgtMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        HashMap map = new HashMap();
        sysMultiLangMgts.forEach(sysMultiLangMgt -> {
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangKey()) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                map.put(sysMultiLangMgt.getLangKey(), sysMultiLangMgt.getLangText());
            }
        });
        return ApiResponse.success(map, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Map<String, Object>> copyLangPack(Map<String, Object> map) {
        String langKey = this.generateLangKey();
        ArrayList<SysMultiLangMgt> sysMultiLangMgtList = new ArrayList<SysMultiLangMgt>();
        for (String key : map.keySet()) {
            SysMultiLangMgt sysMultiLangMgt = new SysMultiLangMgt();
            sysMultiLangMgt.setType(CUSTOM_LANG);
            sysMultiLangMgt.setLangText(String.valueOf(map.get(key)));
            sysMultiLangMgt.setLang(key);
            sysMultiLangMgt.setLangKey(langKey);
            sysMultiLangMgtList.add(sysMultiLangMgt);
        }
        this.saveBatch(sysMultiLangMgtList);
        String dataSourceKey = HussarContextHolder.getConnName();
        this.langAsync.updateLangTime(sysMultiLangMgtList, dataSourceKey);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put(LANG_KEY, langKey);
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            stringMap.put(key, String.valueOf(map.get(key)));
        }
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        Map sortMap = TranslateUtil.sortLangText(stringMap, langList);
        newMap.put(LANG_TEXT, sortMap);
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.langAsync.creatorCachePrefix())) {
            suffix = this.langAsync.creatorCachePrefix();
        }
        HussarCacheUtil.put((String)"lang_text", (Object)(":" + suffix + ":" + langKey), newMap);
        return ApiResponse.success(newMap, (String)"\u590d\u5236\u6210\u529f");
    }

    public ApiResponse<Long> langExport() {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        SysLangTask sysLangTask = new SysLangTask();
        sysLangTask.setTaskId(taskId);
        sysLangTask.setTaskStatus(0);
        sysLangTask.setTaskType(EXPORT);
        this.sysLangTaskService.save((Object)sysLangTask);
        String dataSourceKey = HussarContextHolder.getConnName();
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.langAsync.langExport(sysLangTask, dataSourceKey);
        });
        return ApiResponse.success((Object)taskId);
    }

    @HussarTransactional
    public ApiResponse<Long> langImport(Long appId, Long fileId) {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        SysLangTask sysLangTask = new SysLangTask();
        sysLangTask.setTaskId(taskId);
        sysLangTask.setTaskStatus(0);
        sysLangTask.setTaskType(IMPORT);
        this.sysLangTaskService.save((Object)sysLangTask);
        String dataSourceKey = HussarContextHolder.getConnName();
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.langAsync.langImport(appId, fileId, sysLangTask, dataSourceKey);
        });
        return ApiResponse.success((Object)taskId);
    }

    public ApiResponse<LangImportVo> preImport(Long appId, MultipartFile file) {
        return ApiResponse.success((Object)this.langAsync.preLangImport(appId, file));
    }

    public String generateLangKey() {
        String langKey = this.generateId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey);
        if (this.count((Wrapper)queryWrapper) > 0L) {
            this.generateLangKey();
        }
        return langKey;
    }

    public ApiResponse<Map<String, Object>> getTextByLangKey(String langKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.getLangTextByLangKey(langKey, map);
        return ApiResponse.success(map);
    }

    @HussarTransactional
    public void initialSysLangPack(JSONObject jsonObject, String langCode) {
        ArrayList<String> langKeys = new ArrayList<String>();
        ArrayList<SysMultiLangMgt> sysMultiLangMgtList = new ArrayList<SysMultiLangMgt>();
        for (String key : jsonObject.keySet()) {
            if (!HussarUtils.isNotEmpty((Object)key)) continue;
            Object object = jsonObject.get((Object)key);
            if (langKeys.contains(key)) {
                SysMultiLangMgt multiLangMgt = sysMultiLangMgtList.stream().filter(sysMultiLangMgt -> sysMultiLangMgt.getLangKey().equals(key)).findFirst().get();
                multiLangMgt.setLangText(HussarUtils.isNotEmpty((Object)object) ? String.valueOf(object) : "");
                continue;
            }
            langKeys.add(key);
            SysMultiLangMgt sysMultiLangMgt2 = new SysMultiLangMgt();
            sysMultiLangMgt2.setLangKey(key);
            sysMultiLangMgt2.setLangText(HussarUtils.isNotEmpty((Object)object) ? String.valueOf(object) : "");
            sysMultiLangMgt2.setLang(langCode);
            sysMultiLangMgt2.setType(SYSTEM_LANG);
            sysMultiLangMgtList.add(sysMultiLangMgt2);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysMultiLangMgt::getLang, (Object)langCode)).in(SysMultiLangMgt::getLangKey, langKeys);
        this.remove((Wrapper)wrapper);
        this.saveBatch(sysMultiLangMgtList);
    }

    public ApiResponse<LangQueryVoNoPage> queryListNoPage(Long appId, String langText, String type) {
        List<QueryVo> records = this.sysMultiLangMgtMapper.queryListNoPage(appId, langText, type);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList maps = new ArrayList();
        for (QueryVo queryVo : records) {
            String key = queryVo.getLangKey();
            if (keys.contains(key)) continue;
            keys.add(key);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put(LANG_KEY, key);
            map2.put(LANG_TEXT, new HashMap());
            maps.add(map2);
        }
        maps.forEach(map -> {
            Object object = map.get(LANG_KEY);
            String langKey = String.valueOf(object);
            this.getLangTextByLangKey(langKey, (Map<String, Object>)map);
        });
        LangQueryVoNoPage langQueryVoNoPage = new LangQueryVoNoPage();
        langQueryVoNoPage.setContent(maps);
        return ApiResponse.success((Object)langQueryVoNoPage, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public void saveOrUpdateCache(String langKey) {
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.langAsync.creatorCachePrefix())) {
            suffix = this.langAsync.creatorCachePrefix();
        }
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey);
        List sysMultiLangMgts = ((SysMultiLangMgtMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysMultiLangMgts)) {
            cacheMap.put(LANG_KEY, langKey);
            HashMap<String, String> langTextMap = new HashMap<String, String>();
            for (SysMultiLangMgt sysMultiLangMgt : sysMultiLangMgts) {
                String lang = sysMultiLangMgt.getLang();
                if (!HussarUtils.isNotEmpty((Object)lang) || !langList.contains(lang)) continue;
                langTextMap.put(sysMultiLangMgt.getLang(), sysMultiLangMgt.getLangText());
            }
            Map sortMap = TranslateUtil.sortLangText(langTextMap, langList);
            cacheMap.put(LANG_TEXT, sortMap);
        } else {
            cacheMap.put(LANG_KEY, "");
            cacheMap.put(LANG_TEXT, new HashMap());
        }
        HussarCacheUtil.put((String)"lang_text", (Object)(":" + suffix + ":" + langKey), cacheMap);
    }

    public ApiResponse<Boolean> saveLangPack(SysMultiLangMgtRecDto langPack) {
        JSONObject zhLangPack = (JSONObject)JSONObject.parse((String)langPack.getZh());
        JSONObject enLangPack = (JSONObject)JSONObject.parse((String)langPack.getEn());
        ArrayList<SysMultiLangMgt> sysMultiLangMgts = new ArrayList<SysMultiLangMgt>();
        Set zhKeySet = zhLangPack.keySet();
        for (Object key : zhKeySet) {
            SysMultiLangMgt sysMultiLangMgt2 = new SysMultiLangMgt();
            sysMultiLangMgt2.setLangKey(key.toString());
            Object object = zhLangPack.get(key);
            sysMultiLangMgt2.setLangText(HussarUtils.isNotEmpty((Object)object) ? String.valueOf(object) : "");
            sysMultiLangMgt2.setLang("zh-CN");
            sysMultiLangMgt2.setType(SYSTEM_LANG);
            sysMultiLangMgts.add(sysMultiLangMgt2);
        }
        Set enKeySet = enLangPack.keySet();
        for (Object key : enKeySet) {
            SysMultiLangMgt sysMultiLangMgt3 = new SysMultiLangMgt();
            sysMultiLangMgt3.setLangKey(key.toString());
            Object object = enLangPack.get(key);
            sysMultiLangMgt3.setLangText(HussarUtils.isNotEmpty((Object)object) ? String.valueOf(object) : "");
            sysMultiLangMgt3.setLang("en-US");
            sysMultiLangMgt3.setType(SYSTEM_LANG);
            sysMultiLangMgts.add(sysMultiLangMgt3);
        }
        ArrayList<String> langList = new ArrayList<String>();
        langList.add("en-US");
        langList.add("zh-CN");
        List langKeyList = sysMultiLangMgts.stream().map(SysMultiLangMgt::getLangKey).collect(Collectors.toList());
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysMultiLangMgt::getLang, langList)).in(SysMultiLangMgt::getLangKey, langKeyList));
        LocalDateTime now = LocalDateTime.now();
        sysMultiLangMgts.stream().forEach(sysMultiLangMgt -> sysMultiLangMgt.setCreateTime(now));
        sysMultiLangMgts.stream().forEach(sysMultiLangMgt -> sysMultiLangMgt.setLastTime(now));
        Boolean isSuccess = this.saveBatch(sysMultiLangMgts);
        if (isSuccess.booleanValue()) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    public ApiResponse<SysMultiLangMgtUpdatePackVo> getUpdateLangPack(String lastTime, String locale) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime serachLastTime = LocalDateTime.parse(lastTime, dateTimeFormatter);
        SysMultiLangMgtUpdatePackVo sysMultiLangMgtUpdatePackVo = new SysMultiLangMgtUpdatePackVo();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysMultiLang::getIsShow, (Object)1)).orderByAsc(SysMultiLang::getSort);
        List sysMultiLangs = this.sysMultiLangMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysMultiLangs)) {
            sysMultiLangMgtUpdatePackVo.setFirstOpen(false);
        }
        sysMultiLangMgtUpdatePackVo.setEnabled(TranslateUtil.getIsEnable());
        sysMultiLangMgtUpdatePackVo.setSysMultiLangs(sysMultiLangs);
        LambdaQueryWrapper queryWrapperUpdate = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapperUpdate.eq(SysMultiLangMgt::getLang, (Object)locale)).gt(HussarBaseEntity::getLastTime, (Object)serachLastTime);
        List sysMultiLangMgts = this.sysMultiLangMgtMapper.selectList((Wrapper)queryWrapperUpdate);
        HashMap map = new HashMap();
        sysMultiLangMgts.forEach(sysMultiLangMgt -> {
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangKey()) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                map.put(sysMultiLangMgt.getLangKey(), sysMultiLangMgt.getLangText());
            }
        });
        sysMultiLangMgtUpdatePackVo.setContent(map);
        return ApiResponse.success((Object)sysMultiLangMgtUpdatePackVo);
    }
}

