/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.run;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMgtMapper;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.impl.LangAsync;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1000003)
public class LangTextRunner
implements ApplicationRunner {
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    @Resource
    private SysMultiLangMgtMapper sysMultiLangMgtMapper;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private LangAsync langAsync;

    public void run(ApplicationArguments args) throws Exception {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseTenantExecutor.execute(() -> {
            String suffix = "master";
            if (HussarUtils.isNotEmpty((Object)this.langAsync.creatorCachePrefix())) {
                suffix = this.langAsync.creatorCachePrefix();
            }
            String cacheName = "lang_text";
            List cacheKeys = HussarCacheUtil.getKeysLike((String)cacheName, (String)(":" + suffix + ":?"));
            for (String cacheKey : cacheKeys) {
                HussarCacheUtil.evict((String)cacheName, (Object)cacheKey);
            }
            HussarCacheUtil.evict((String)("lang_list:" + suffix), (Object)"lang_list");
            ArrayList<String> langList = new ArrayList<String>();
            this.langAsync.getLangs(langList);
            List sysMultiLangMgts = this.sysMultiLangMgtMapper.selectList((Wrapper)new QueryWrapper());
            for (int i = 0; i < sysMultiLangMgts.size(); ++i) {
                SysMultiLangMgt sysMultiLangMgtRes = (SysMultiLangMgt)sysMultiLangMgts.get(i);
                List collects = sysMultiLangMgts.stream().filter(res -> sysMultiLangMgtRes.getLangKey().equalsIgnoreCase(res.getLangKey())).collect(Collectors.toList());
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (HussarUtils.isNotEmpty((Object)sysMultiLangMgts)) {
                    HashMap<String, String> langTextMap = new HashMap<String, String>();
                    for (SysMultiLangMgt collect : collects) {
                        String lang = collect.getLang();
                        if (!HussarUtils.isNotEmpty((Object)lang) || !langList.contains(lang)) continue;
                        langTextMap.put(collect.getLang(), collect.getLangText());
                    }
                    for (int j = 0; j < langList.size(); ++j) {
                        if (langTextMap.containsKey(langList.get(j))) continue;
                        langTextMap.put((String)langList.get(j), "");
                    }
                    map.put(LANG_KEY, sysMultiLangMgtRes.getLangKey());
                    Map sortMap = TranslateUtil.sortLangText(langTextMap, langList);
                    map.put(LANG_TEXT, sortMap);
                } else {
                    map.put(LANG_KEY, "");
                    map.put(LANG_TEXT, new HashMap());
                }
                HussarCacheUtil.put((String)"lang_text", (Object)(":" + suffix + ":" + sysMultiLangMgtRes.getLangKey()), map);
            }
        });
    }
}

