/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.lang.IHussarCommonMultiLangMgtService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.lang.dto.SysBatchMultiLangMgtDto;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.service.ISysBatchLangTranslateService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangBoService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;

public class TranslateUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(TranslateUtil.class);
    private static ISysMultiLangMgtBoService sysMultiLangMgtService = TranslateUtil.initSysMultiLangMgtService();
    private static ISysMultiLangBoService sysMultiLangService = TranslateUtil.initSysMultiLangService();
    private static ISysBatchLangTranslateService sysBatchLangTranslateService = TranslateUtil.initSysBatchLangTranslateService();
    private static final String DEFAULT_LANGLE = "zh-CN";
    private static final String LANGTEXT = "langText";

    private static ISysMultiLangMgtBoService initSysMultiLangMgtService() {
        try {
            return (ISysMultiLangMgtBoService)SpringContextHolder.getBean(ISysMultiLangMgtBoService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ISysMultiLangBoService initSysMultiLangService() {
        try {
            return (ISysMultiLangBoService)SpringContextHolder.getBean(ISysMultiLangBoService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ISysBatchLangTranslateService initSysBatchLangTranslateService() {
        try {
            return (ISysBatchLangTranslateService)SpringContextHolder.getBean(ISysBatchLangTranslateService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IHussarCommonMultiLangMgtService initHussarCommonMultiLangMgtService() {
        try {
            return (IHussarCommonMultiLangMgtService)SpringContextHolder.getBean(IHussarCommonMultiLangMgtService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void translateJsonArray(JSONArray jsonArray, Function<JSONObject, String> getTranslateTagFunction, BiConsumer<JSONObject, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty((Object)jsonArray)) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String translateTag = getTranslateTagFunction.apply(jsonObject);
                String newName = TranslateUtil.getTranslateName(translateTag);
                if (!HussarUtils.isNotEmpty((Object)newName)) continue;
                setProcessNameFunction.accept(jsonObject, newName);
            }
        }
    }

    public static <T> void translate(List<T> list, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (HussarUtils.isNotEmpty(list)) {
            ArrayList<String> langkeyList = new ArrayList<String>();
            for (T t : list) {
                String translateTag = getTranslateTagFunction.apply(t);
                if (!HussarUtils.isNotEmpty((Object)translateTag)) continue;
                langkeyList.add(translateTag);
            }
            SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
            sysBatchMultiLangMgtDto.setLangCode(lang);
            sysBatchMultiLangMgtDto.setLangKeys(langkeyList);
            Map<String, Object> resMap = sysBatchLangTranslateService.getLangTextByListLangKey(sysBatchMultiLangMgtDto);
            for (T t : list) {
                if (!HussarUtils.isNotEmpty((Object)getTranslateTagFunction.apply(t)) || !HussarUtils.isNotEmpty((Object)String.valueOf(resMap.get(getTranslateTagFunction.apply(t))))) continue;
                setProcessNameFunction.accept(t, String.valueOf(resMap.get(getTranslateTagFunction.apply(t))));
            }
        }
    }

    public static <T> void translate(T entity, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        String translateTag;
        String newName;
        if (!TranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (HussarUtils.isNotEmpty(entity) && HussarUtils.isNotEmpty((Object)(newName = TranslateUtil.getTranslateName(translateTag = getTranslateTagFunction.apply(entity))))) {
            setProcessNameFunction.accept(entity, newName);
        }
    }

    public static String getTranslateName(String translateTag) {
        if (!TranslateUtil.getIsEnable()) {
            return TranslateUtil.getDefaultTranslateName(translateTag);
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (!langMap.containsKey(LANGTEXT) || HussarUtils.isEmpty(langMap.get(LANGTEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANGTEXT)).get(lang))) {
            return null;
        }
        return (String)((Map)langMap.get(LANGTEXT)).get(lang);
    }

    public static String getDefaultTranslateName(String translateTag) {
        String lang = DEFAULT_LANGLE;
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (!langMap.containsKey(LANGTEXT) || HussarUtils.isEmpty(langMap.get(LANGTEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANGTEXT)).get(lang))) {
            return null;
        }
        return (String)((Map)langMap.get(LANGTEXT)).get(lang);
    }

    public static <T> void translateByJson(T entity, Function<T, String> getTranslateTagFunction) {
        String i18nKeyString;
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty(entity)) {
            return;
        }
        if (HussarUtils.isNotEmpty(entity) && HussarUtils.isNotEmpty((Object)(i18nKeyString = getTranslateTagFunction.apply(entity)))) {
            JSONObject i18nKey = JSONObject.parseObject((String)i18nKeyString);
            i18nKey.forEach((key, value) -> {
                try {
                    if (TranslateUtil.hasField(entity.getClass(), key) && HussarUtils.isNotEmpty((Object)value)) {
                        Method setMethod = entity.getClass().getMethod("set" + key.substring(0, 1).toUpperCase() + key.substring(1), String.class);
                        String newName = TranslateUtil.getTranslateName(String.valueOf(value));
                        setMethod.invoke(entity, newName);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u56fd\u9645\u5316\u7ffb\u8bd1\u5b57\u6bb5JSON\u7c7b\u578b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            });
        }
    }

    public static <T> void translateByJson(List<T> list, Function<T, String> getTranslateTagFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty(list)) {
            return;
        }
        if (HussarUtils.isNotEmpty(list)) {
            for (Object t : list) {
                String i18nKeyString = getTranslateTagFunction.apply(t);
                if (!HussarUtils.isNotEmpty((Object)i18nKeyString)) continue;
                JSONObject i18nKey = JSONObject.parseObject((String)i18nKeyString);
                i18nKey.forEach((key, value) -> {
                    try {
                        if (TranslateUtil.hasField(t.getClass(), key) && HussarUtils.isNotEmpty((Object)value)) {
                            Method setMethod = t.getClass().getMethod("set" + key.substring(0, 1).toUpperCase() + key.substring(1), String.class);
                            String newName = TranslateUtil.getTranslateName(String.valueOf(value));
                            setMethod.invoke(t, newName);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u56fd\u9645\u5316\u7ffb\u8bd1\u5b57\u6bb5JSON\u7c7b\u578b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                    }
                });
            }
        }
    }

    public static Map<String, Object> getLangTextByListLangKey(SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty((Object)sysBatchMultiLangMgtDto) || sysBatchLangTranslateService == null) {
            return null;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        if (TranslateUtil.getIsEnable()) {
            map = sysBatchLangTranslateService.getLangTextByListLangKey(sysBatchMultiLangMgtDto);
        }
        return map;
    }

    public static <T> void translate(Page<T> pages, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty(pages) || HussarUtils.isEmpty((Object)pages.getRecords())) {
            return;
        }
        if (HussarUtils.isNotEmpty(pages)) {
            List records = pages.getRecords();
            TranslateUtil.translate(records, getTranslateTagFunction, setProcessNameFunction);
            pages.setRecords(records);
        }
    }

    public static String getDefaultLang() {
        SysMultiLang defaultLang = sysMultiLangService.getDefaultLang();
        if (HussarUtils.isEmpty((Object)((Object)defaultLang))) {
            return DEFAULT_LANGLE;
        }
        return defaultLang.getLangCode();
    }

    public static boolean getIsEnable() {
        return Boolean.valueOf(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.lang.enable-lang-service"));
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        try {
            ArrayList<String> allFieldName = new ArrayList<String>();
            TranslateUtil.getAllField(clazz, allFieldName);
            return HussarUtils.isNotEmpty(allFieldName) && allFieldName.contains(fieldName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, String> sortLangText(Map<String, String> map, List<String> langs) {
        LinkedHashMap<String, String> resMap = new LinkedHashMap<String, String>();
        if (HussarUtils.isNotEmpty(map)) {
            for (String lang : langs) {
                resMap.put(lang, map.get(lang));
            }
        }
        return resMap;
    }

    public static void getAllField(Class<?> clazz, List<String> allFieldName) {
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            allFieldName.add(declaredFields[i].getName());
        }
        Class<?> superclass = clazz.getSuperclass();
        if (HussarUtils.isNotEmpty(superclass)) {
            TranslateUtil.getAllField(superclass, allFieldName);
        }
    }

    public static String getSystemDefaultTranslateName(String translateTag) {
        if (!TranslateUtil.getIsEnable()) {
            return null;
        }
        String lang = TranslateUtil.getDefaultLang();
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (!langMap.containsKey(LANGTEXT) || HussarUtils.isEmpty(langMap.get(LANGTEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANGTEXT)).get(lang))) {
            return null;
        }
        return (String)((Map)langMap.get(LANGTEXT)).get(lang);
    }

    public static String getTranslateName(String translateTag, String fallBackString) {
        if (!TranslateUtil.getIsEnable()) {
            String defaultTranslateName = TranslateUtil.getDefaultTranslateName(translateTag);
            if (HussarUtils.isNotEmpty((Object)defaultTranslateName)) {
                return defaultTranslateName;
            }
            return fallBackString;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return fallBackString;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (!langMap.containsKey(LANGTEXT) || HussarUtils.isEmpty(langMap.get(LANGTEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANGTEXT)).get(lang))) {
            return fallBackString;
        }
        String transString = (String)((Map)langMap.get(LANGTEXT)).get(lang);
        if (HussarUtils.isNotEmpty((Object)transString)) {
            return transString;
        }
        return fallBackString;
    }
}

