/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.lang.dto.SysBatchMultiLangMgtDto;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.service.ISysBatchLangTranslateService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;

public class TranslateUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(TranslateUtil.class);
    private static ISysMultiLangMgtService sysMultiLangMgtService = TranslateUtil.initSysMultiLangMgtService();
    private static ISysMultiLangService sysMultiLangService = TranslateUtil.initSysMultiLangService();
    private static ISysBatchLangTranslateService sysBatchLangTranslateService = TranslateUtil.initSysBatchLangTranslateService();
    private static final String DEFAULT_LANGLE = "zh-CN";

    private static ISysMultiLangMgtService initSysMultiLangMgtService() {
        try {
            return (ISysMultiLangMgtService)SpringContextHolder.getBean(ISysMultiLangMgtService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ISysMultiLangService initSysMultiLangService() {
        try {
            return (ISysMultiLangService)SpringContextHolder.getBean(ISysMultiLangService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ISysBatchLangTranslateService initSysBatchLangTranslateService() {
        try {
            return (ISysBatchLangTranslateService)SpringContextHolder.getBean(ISysBatchLangTranslateService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void translateJsonArray(JSONArray jsonArray, Function<JSONObject, String> getTranslateTagFunction, BiConsumer<JSONObject, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty((Object)jsonArray)) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String translateTag = getTranslateTagFunction.apply(jsonObject);
            String newName = TranslateUtil.getTranslateName(translateTag);
            if (!HussarUtils.isNotEmpty((Object)newName)) continue;
            setProcessNameFunction.accept(jsonObject, newName);
        }
    }

    public static <T> void translate(List<T> list, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        ArrayList<String> langkeyList = new ArrayList<String>();
        for (T t : list) {
            String translateTag = getTranslateTagFunction.apply(t);
            if (!HussarUtils.isNotEmpty((Object)translateTag)) continue;
            langkeyList.add(translateTag);
        }
        SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
        sysBatchMultiLangMgtDto.setLangCode(lang);
        sysBatchMultiLangMgtDto.setLangKeys(langkeyList);
        Map<String, Object> resMap = sysBatchLangTranslateService.getLangTextByListLangKey(sysBatchMultiLangMgtDto);
        for (T t : list) {
            if (!HussarUtils.isNotEmpty((Object)getTranslateTagFunction.apply(t)) || !HussarUtils.isNotEmpty((Object)String.valueOf(resMap.get(getTranslateTagFunction.apply(t))))) continue;
            setProcessNameFunction.accept(t, String.valueOf(resMap.get(getTranslateTagFunction.apply(t))));
        }
    }

    public static <T> void translate(T entity, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        String translateTag = getTranslateTagFunction.apply(entity);
        String newName = TranslateUtil.getTranslateName(translateTag);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            setProcessNameFunction.accept(entity, newName);
        }
    }

    public static String getTranslateName(String translateTag) {
        if (!TranslateUtil.getIsEnable()) {
            return TranslateUtil.getDefaultTranslateName(translateTag);
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (!langMap.containsKey("langText") || HussarUtils.isEmpty(langMap.get("langText")) || HussarUtils.isEmpty(((Map)langMap.get("langText")).get(lang))) {
            return null;
        }
        return (String)((Map)langMap.get("langText")).get(lang);
    }

    public static String getDefaultTranslateName(String translateTag) {
        String lang = DEFAULT_LANGLE;
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (!langMap.containsKey("langText") || HussarUtils.isEmpty(langMap.get("langText")) || HussarUtils.isEmpty(((Map)langMap.get("langText")).get(lang))) {
            return null;
        }
        return (String)((Map)langMap.get("langText")).get(lang);
    }

    public static <T> void translateByJson(T entity, Function<T, String> getTranslateTagFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty(entity)) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        String i18nKeyString = getTranslateTagFunction.apply(entity);
        if (HussarUtils.isNotEmpty((Object)i18nKeyString)) {
            JSONObject i18nKey = JSONObject.parseObject((String)i18nKeyString);
            i18nKey.forEach((key, value) -> {
                try {
                    if (TranslateUtil.hasField(entity.getClass(), key)) {
                        Method setMethod = entity.getClass().getMethod("set" + key.substring(0, 1).toUpperCase() + key.substring(1), String.class);
                        String newName = TranslateUtil.getTranslateName(String.valueOf(value));
                        setMethod.invoke(entity, newName);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u56fd\u9645\u5316\u7ffb\u8bd1\u5b57\u6bb5JSON\u7c7b\u578b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            });
        }
    }

    public static <T> void translateByJson(List<T> list, Function<T, String> getTranslateTagFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty(list)) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        for (Object t : list) {
            String i18nKeyString = getTranslateTagFunction.apply(t);
            if (!HussarUtils.isNotEmpty((Object)i18nKeyString)) continue;
            JSONObject i18nKey = JSONObject.parseObject((String)i18nKeyString);
            i18nKey.forEach((key, value) -> {
                try {
                    if (TranslateUtil.hasField(t.getClass(), key)) {
                        Method setMethod = t.getClass().getMethod("set" + key.substring(0, 1).toUpperCase() + key.substring(1), String.class);
                        String newName = TranslateUtil.getTranslateName(String.valueOf(value));
                        setMethod.invoke(t, newName);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u56fd\u9645\u5316\u7ffb\u8bd1\u5b57\u6bb5JSON\u7c7b\u578b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            });
        }
    }

    public static Map<String, Object> getLangTextByListLangKey(SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty((Object)sysBatchMultiLangMgtDto) || sysBatchLangTranslateService == null) {
            return null;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        if (TranslateUtil.getIsEnable()) {
            map = sysBatchLangTranslateService.getLangTextByListLangKey(sysBatchMultiLangMgtDto);
        }
        return map;
    }

    public static <T> void translate(Page<T> pages, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        if (!TranslateUtil.getIsEnable() || HussarUtils.isEmpty(pages) || HussarUtils.isEmpty((Object)pages.getRecords())) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        List records = pages.getRecords();
        TranslateUtil.translate(records, getTranslateTagFunction, setProcessNameFunction);
        pages.setRecords(records);
    }

    public static String getDefaultLang() {
        SysMultiLang defaultLang = sysMultiLangService.getDefaultLang();
        if (HussarUtils.isEmpty((Object)((Object)defaultLang))) {
            return DEFAULT_LANGLE;
        }
        return defaultLang.getLangCode();
    }

    public static boolean getIsEnable() {
        return Boolean.valueOf(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.lang.enable-lang-service"));
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        try {
            clazz.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static Map<String, String> sortLangText(Map<String, String> map, List<String> langs) {
        LinkedHashMap<String, String> resMap = new LinkedHashMap<String, String>();
        if (HussarUtils.isNotEmpty(map)) {
            for (String lang : langs) {
                resMap.put(lang, map.get(lang));
            }
        }
        return resMap;
    }
}

