/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.identity;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkIdentityException;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryStaffDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkSearchOrganDto;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkDelStatusEnum;
import com.jxdinfo.hussar.iam.sdk.api.service.identity.IHussarIamSdkStaffService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkStaffVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamStaffMapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarIamSdkStaffServiceImpl
implements IHussarIamSdkStaffService {
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    private HussarIamStaffMapper hussarIamStaffMapper;

    public IamSdkStaffVo getByUserId(Long userId) {
        IamSdkStaffVo staffVo = new IamSdkStaffVo();
        SysUsers user = this.sysUsersService.getById(userId);
        if (HussarUtils.isEmpty((Object)user)) {
            throw new IamSdkIdentityException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SysStaff staff = (SysStaff)this.sysStaffService.getById((Serializable)user.getEmployeeId());
        this.wrapStaff(staff, staffVo);
        return staffVo;
    }

    public List<IamSdkStaffVo> list(IamSdkQueryStaffDto queryStaffDto) {
        ArrayList<IamSdkStaffVo> result = new ArrayList<IamSdkStaffVo>();
        String staffName = queryStaffDto.getStaffName();
        String staffCode = queryStaffDto.getStaffCode();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(HussarUtils.isNotEmpty((Object)staffName), SysStaff::getName, (Object)staffName)).like(HussarUtils.isNotEmpty((Object)staffCode), SysStaff::getStaffCode, (Object)staffCode)).orderByAsc(SysStaff::getStaffOrder);
        List staffList = this.sysStaffService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)staffList)) {
            for (SysStaff staff : staffList) {
                IamSdkStaffVo staffVo = new IamSdkStaffVo();
                this.wrapStaff(staff, staffVo);
                result.add(staffVo);
            }
        }
        return result;
    }

    public Page<IamSdkStaffVo> page(IamSdkQueryStaffDto queryStaffDto) {
        Long current = queryStaffDto.getCurrent();
        Long size = queryStaffDto.getSize();
        String staffName = queryStaffDto.getStaffName();
        String staffCode = queryStaffDto.getStaffCode();
        Page staffVoIPage = new Page();
        staffVoIPage.setCurrent(current.longValue());
        staffVoIPage.setSize(size.longValue());
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("staffName", staffName);
        queryParams.put("staffCode", staffCode);
        List<IamSdkStaffVo> staffList = this.hussarIamStaffMapper.staffPage((Page<IamSdkStaffVo>)staffVoIPage, queryParams);
        staffVoIPage.setRecords(staffList);
        return staffVoIPage;
    }

    public Page<IamSdkStaffVo> getPageByOrganId(IamSdkSearchOrganDto searchOrganDto) {
        Long current = searchOrganDto.getCurrent();
        Long size = searchOrganDto.getSize();
        Long organId = searchOrganDto.getOrganId();
        Page staffVoIPage = new Page();
        staffVoIPage.setCurrent(current.longValue());
        staffVoIPage.setSize(size.longValue());
        List<IamSdkStaffVo> staffList = this.hussarIamStaffMapper.getStaffPageByOrganId((Page<IamSdkStaffVo>)staffVoIPage, organId);
        staffVoIPage.setRecords(staffList);
        return staffVoIPage;
    }

    public List<IamSdkStaffVo> getByOrganId(Long organId) {
        return this.hussarIamStaffMapper.getStaffByOrganId(organId);
    }

    public Page<IamSdkStaffVo> allSubStaffPage(IamSdkSearchOrganDto searchOrganDto) {
        Long current = searchOrganDto.getCurrent();
        Long size = searchOrganDto.getSize();
        Long organId = searchOrganDto.getOrganId();
        Page staffVoIPage = new Page();
        staffVoIPage.setCurrent(current.longValue());
        staffVoIPage.setSize(size.longValue());
        ArrayList<Long> organIds = new ArrayList<Long>(Collections.singletonList(organId));
        List<Long> struIdList = this.getSubOrganByIds(organIds);
        List<Object> staffList = new ArrayList();
        if (HussarUtils.isNotEmpty(struIdList)) {
            staffList = this.hussarIamStaffMapper.getStaffPageByOrganIds((Page<IamSdkStaffVo>)staffVoIPage, struIdList);
        }
        staffVoIPage.setRecords(staffList);
        return staffVoIPage;
    }

    public List<IamSdkStaffVo> allSubStaffList(Long organId) {
        ArrayList<Long> organIds = new ArrayList<Long>(Collections.singletonList(organId));
        List<Long> struIdList = this.getSubOrganByIds(organIds);
        List<IamSdkStaffVo> staffList = new ArrayList<IamSdkStaffVo>();
        if (HussarUtils.isNotEmpty(struIdList)) {
            staffList = this.hussarIamStaffMapper.getStaffByOrganIds(struIdList);
        }
        return staffList;
    }

    private void wrapStaff(SysStaff staff, IamSdkStaffVo staffVo) {
        staffVo.setStaffId(staff.getId());
        staffVo.setStaffName(staff.getName());
        staffVo.setStaffCode(staff.getStaffCode());
        staffVo.setBirthday(staff.getBirthday());
        staffVo.setSex(staff.getSex());
        staffVo.setIdCard(staff.getIdcard());
        staffVo.setAddress(staff.getAddress());
        staffVo.setWorkNo(staff.getWorkId());
        staffVo.setWorkDate(staff.getWorkDate());
        staffVo.setGraduateDate(staff.getGraduateDate());
        staffVo.setGraduateSchool(staff.getGraduateSchool());
    }

    public List<Long> getSubOrganByIds(List<Long> organIds) {
        if (HussarUtils.isEmpty(organIds)) {
            return new ArrayList<Long>();
        }
        List list = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
        List seqList = list.stream().map(SysStru::getStruSeq).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(seqList)) {
            for (String seq : seqList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruSeq, (Object)seq);
            }
        }
        List sysStrus = this.sysStruService.list((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
        return sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
    }
}

