/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.sync;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.post.service.ISysPostAuditService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.postmanager.PostChangeNotify;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkPageInfo;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkPostDto;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncPost;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncStru;
import com.jxdinfo.hussar.iam.sdk.api.service.sync.IHussarIamSdkSyncPostService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkDataMapping;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkPostInfoVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamPostMapper;
import com.jxdinfo.hussar.iam.sdk.server.dao.sync.SyncPostMapper;
import com.jxdinfo.hussar.iam.sdk.server.dao.sync.SyncStruMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.server.service.impl.sync.hussarIamSdkSyncPostServiceImpl")
public class HussarIamSdkSyncPostServiceImpl
implements IHussarIamSdkSyncPostService {
    @Resource
    private HussarIamPostMapper hussarIamPostMapper;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private ISysStruPostAuditService sysStruPostAuditService;
    @Resource
    private ISysUserPostAuditService sysUserPostAuditService;
    @Resource
    private ISysPostRoleAuditService sysPostRoleAuditService;
    @Resource
    private ISysPostAuditService sysPostAuditService;
    @Resource
    private ISysPostRoleService sysPostRoleService;
    @Resource
    private ISysUserPostService sysUserPostService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SyncPostMapper syncPostMapper;
    @Resource
    private SyncStruMapper syncStruMapper;
    @Resource
    private PostChangeNotify postChangeNotify;

    public Page<IamSdkPostInfoVo> getAllPostInfo(IamSdkPageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)((PageInfo)JSON.parseObject((String)JSON.toJSONString((Object)pageInfo), PageInfo.class)));
        List<IamSdkPostInfoVo> list = this.hussarIamPostMapper.getAllPostInfo((Page<IamSdkPostInfoVo>)page);
        if (HussarUtils.isEmpty(list)) {
            page.setRecords(list);
            return page;
        }
        List postIds = list.stream().map(IamSdkPostInfoVo::getPostId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruPost::getPostId, postIds);
        List struPosts = this.sysStruPostService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)struPosts)) {
            Map map = struPosts.stream().collect(Collectors.groupingBy(SysStruPost::getPostId, Collectors.mapping(SysStruPost::getStruId, Collectors.toList())));
            for (IamSdkPostInfoVo vo : list) {
                List struIds = map.get(vo.getPostId());
                if (!HussarUtils.isNotEmpty(struIds)) continue;
                vo.setStruIds(struIds);
            }
        }
        page.setRecords(list);
        return page;
    }

    @HussarTransactional
    public IamSdkDataMapping addPost(IamSdkPostDto postDto) {
        String postId = postDto.getPostId();
        String postName = postDto.getPostName();
        String postCode = postDto.getPostCode();
        AssertUtil.isNotEmpty((String)postId, (String)"\u5c97\u4f4did\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((String)postName, (String)"\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Long count = this.syncPostMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SyncPost::getPostId, (Object)postId));
        AssertUtil.isFalse((count > 0L ? 1 : 0) != 0, (String)"\u540c\u6b65\u65b0\u589e\u5c97\u4f4d\u5931\u8d25\uff01\u8be5\u5c97\u4f4d\u5df2\u540c\u6b65\uff01");
        SysPost post = new SysPost();
        Long newPostId = HussarUtils.isEmpty((Object)postDto.getPostIdLong()) ? Long.valueOf(IdWorker.getId((Object)post)) : postDto.getPostIdLong();
        post.setId(newPostId);
        post.setPostName(postName);
        post.setPostDesc(postDto.getPostDesc());
        post.setOrganTypeCode(postDto.getOrganTypeCode());
        Integer postOrder = this.hussarIamPostMapper.getMaxOrder();
        postOrder = HussarUtils.isEmpty((Object)postOrder) ? Integer.valueOf(1) : Integer.valueOf(postOrder + 1);
        post.setPostOrder(postOrder);
        if (HussarUtils.isEmpty((Object)postCode)) {
            String code = this.getCode();
            post.setPostCode(code);
        } else {
            post.setPostCode(postCode);
        }
        boolean flag = this.hussarIamPostMapper.insert(post) > 0;
        AssertUtil.isTrue((boolean)flag, (String)"\u540c\u6b65\u65b0\u589e\u5c97\u4f4d\u5931\u8d25\uff01");
        this.saveStruPost(postDto, newPostId);
        SyncPost syncPost = new SyncPost();
        syncPost.setPostId(postId);
        syncPost.setIamPostId(newPostId);
        this.syncPostMapper.insert(syncPost);
        this.postChangeNotify.notify(DataChangeType.INSERT, new Object[]{post});
        return new IamSdkDataMapping(newPostId, postId);
    }

    @HussarTransactional
    public Boolean editPost(IamSdkPostDto postDto) {
        String outPostId = postDto.getPostId();
        SyncPost syncPost = (SyncPost)this.syncPostMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncPost::getPostId, (Object)outPostId));
        AssertUtil.isNotNull((Object)syncPost, (String)"\u540c\u6b65\u4fee\u6539\u5c97\u4f4d\u5931\u8d25\uff01\u8be5\u5c97\u4f4d\u672a\u540c\u6b65\uff01");
        Long postId = syncPost.getIamPostId();
        SysPost post = (SysPost)this.hussarIamPostMapper.selectById(postId);
        AssertUtil.isNotNull((Object)post, (String)"\u540c\u6b65\u4fee\u6539\u5c97\u4f4d\u5931\u8d25\uff01\u8be5\u5c97\u4f4d\u672a\u540c\u6b65\uff01");
        if (HussarUtils.isNotEmpty((Object)postDto.getPostName())) {
            post.setPostName(StringUtils.trimToEmpty((String)postDto.getPostName()));
        }
        post.setOrganTypeCode(postDto.getOrganTypeCode());
        post.setPostDesc(postDto.getPostDesc());
        this.hussarIamPostMapper.updateById(post);
        this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
        this.saveStruPost(postDto, postId);
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        return Boolean.TRUE;
    }

    @HussarTransactional
    public Boolean deletePost(String outPostId) {
        SyncPost syncPost = (SyncPost)this.syncPostMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncPost::getPostId, (Object)outPostId));
        if (HussarUtils.isNotEmpty((Object)syncPost)) {
            Long postId = syncPost.getIamPostId();
            SysPost post = (SysPost)this.hussarIamPostMapper.selectById(postId);
            this.sysStruPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPostAudit::getPostId, (Object)postId)).eq(SysStruPostAudit::getAuditStatus, (Object)"0"));
            this.sysUserPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getPostId, (Object)postId)).eq(SysUserPostAudit::getAuditStatus, (Object)"0"));
            this.sysPostRoleAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getPostId, (Object)postId)).eq(SysPostRoleAudit::getAuditStatus, (Object)"0"));
            this.sysPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostAudit::getPostId, (Object)postId)).eq(SysPostAudit::getAuditStatus, (Object)"0"));
            this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId));
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId));
            this.hussarIamPostMapper.deleteById(postId);
            this.syncPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SyncPost::getPostId, (Object)outPostId));
            this.postChangeNotify.notify(DataChangeType.DELETE, new Object[]{post});
        }
        return Boolean.TRUE;
    }

    private void saveStruPost(IamSdkPostDto postDto, Long newPostId) {
        LambdaQueryWrapper wrapper;
        List syncStrus;
        List organIds;
        List parentIds = postDto.getParentIds();
        if (HussarUtils.isNotEmpty((Object)parentIds) && HussarUtils.isNotEmpty(organIds = (syncStrus = this.syncStruMapper.selectList((Wrapper)(wrapper = LambdaQueryUtil.getMultiQueryWrapper(SyncStru::getStruId, (List)parentIds)))).stream().map(SyncStru::getIamStruId).distinct().collect(Collectors.toList()))) {
            ArrayList<SysStruPost> organPostList = new ArrayList<SysStruPost>();
            for (Long organId : organIds) {
                SysStruPost sysStruPost = new SysStruPost();
                sysStruPost.setPostId(newPostId);
                sysStruPost.setStruId(organId);
                organPostList.add(sysStruPost);
            }
            if (HussarUtils.isNotEmpty(organPostList)) {
                this.sysStruPostService.saveBatch(organPostList, organPostList.size());
            }
        }
    }

    private String getCode() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        String currentCode = "";
        long currentCount = 1L;
        long num = 0L;
        String firstCode = "";
        while (currentCount != 0L) {
            lambdaQueryWrapper.clear();
            currentCode = this.sysIdtableService.getCurrentCode("POST_CODE", "SYS_POST");
            if (++num == 1L) {
                firstCode = currentCode;
            }
            AssertUtil.isFalse((num > 1L && currentCode.equals(firstCode) ? 1 : 0) != 0, (String)"\u540c\u6b65\u5c97\u4f4d\u5931\u8d25\uff01\u65e0\u53ef\u7528\u7f16\u7801\uff01");
            lambdaQueryWrapper.eq(SysPost::getPostCode, (Object)currentCode);
            currentCount = this.hussarIamPostMapper.selectCount((Wrapper)lambdaQueryWrapper);
        }
        return currentCode;
    }
}

