/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.identity;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryPostDto;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkDelStatusEnum;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkPostEnum;
import com.jxdinfo.hussar.iam.sdk.api.exception.IamSdkPostException;
import com.jxdinfo.hussar.iam.sdk.api.service.identity.IHussarIamSdkPostService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkPostVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamPostMapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarIamSdkPostServiceImpl
implements IHussarIamSdkPostService {
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private IHussarBasePostService hussarBasePostService;
    @Autowired
    private ISysStruPostService sysStruPostService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private HussarIamPostMapper hussarIamPostMapper;
    @Autowired
    private ISysPostRoleService sysPostRoleService;

    public List<IamSdkPostVo> getByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            throw new IamSdkPostException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        lambdaQueryWrapper.eq(SysUserPost::getUserId, (Object)userId);
        List sysUserPostList = this.sysUserPostService.list((Wrapper)lambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysUserPostList, (String)"\u7528\u6237\u5c97\u4f4d\u5173\u7cfb\u4e0d\u5b58\u5728");
        Set<Long> postIds = sysUserPostList.stream().map(SysUserPost::getPostId).collect(Collectors.toSet());
        Map<Long, IamSdkPostVo> struPostMap = this.getStruPostMap(new ArrayList<Long>(postIds));
        List<SysPost> sysPostList = this.getSysPostList(postIds);
        return this.buildIamSdkPostVoList(sysPostList, struPostMap);
    }

    private Map<Long, IamSdkPostVo> getStruPostMap(List<Long> postIds) {
        if (CollectionUtils.isEmpty(postIds)) {
            return Maps.newHashMap();
        }
        List<IamSdkPostVo> struPostList = this.hussarIamPostMapper.getPostListByPostIds(new ArrayList<Long>(postIds));
        AssertUtil.isNotEmpty(struPostList, (String)"\u5c97\u4f4d\u4e0d\u5b58\u5728");
        Map<Long, IamSdkPostVo> iamSdkPostVoMap = struPostList.stream().collect(Collectors.toMap(IamSdkPostVo::getPostId, Function.identity(), (oldVal, newVal) -> newVal));
        return iamSdkPostVoMap;
    }

    public List<IamSdkPostVo> list(IamSdkQueryPostDto iamSdkQueryPostDTO) {
        if (Objects.isNull(iamSdkQueryPostDTO)) {
            throw new IamSdkPostException("\u5c97\u4f4d\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.hussarIamPostMapper.list(iamSdkQueryPostDTO);
    }

    public Page<IamSdkPostVo> page(IamSdkQueryPostDto iamSdkQueryPostDTO) {
        Long current = iamSdkQueryPostDTO.getCurrent();
        Long size = iamSdkQueryPostDTO.getSize();
        if (Objects.isNull(iamSdkQueryPostDTO.getCurrent()) || Objects.isNull(iamSdkQueryPostDTO.getSize())) {
            current = 1L;
            size = 15L;
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(SdkPostEnum.POST_NAME.getName(), iamSdkQueryPostDTO.getPostName());
        queryParams.put(SdkPostEnum.ORGAN_TYPES.getName(), iamSdkQueryPostDTO.getOrganTypes());
        Page postVoPage = new Page(current.longValue(), size.longValue());
        List<IamSdkPostVo> postVoList = this.hussarIamPostMapper.page((Page<IamSdkPostVo>)postVoPage, queryParams);
        postVoPage.setRecords((List)(CollectionUtils.isEmpty(postVoList) ? Lists.newArrayList() : postVoList));
        return postVoPage;
    }

    public List<IamSdkPostVo> getByRoleId(Long roleId) {
        if (Objects.isNull(roleId)) {
            throw new IamSdkPostException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper sysPostRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysPostRoleLambdaQueryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        sysPostRoleLambdaQueryWrapper.eq(SysPostRole::getRoleId, (Object)roleId);
        List sysPostRoleList = this.sysPostRoleService.list((Wrapper)sysPostRoleLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysPostRoleList, (String)"\u89d2\u8272\u4e0e\u5c97\u4f4d\u5173\u7cfb\u4e0d\u5b58\u5728");
        Set<Long> postIds = sysPostRoleList.stream().map(SysPostRole::getPostId).collect(Collectors.toSet());
        List<SysPost> sysPostList = this.getSysPostList(postIds);
        Map<Long, IamSdkPostVo> struPostMap = this.getStruPostMap(new ArrayList<Long>(postIds));
        return this.buildIamSdkPostVoList(sysPostList, struPostMap);
    }

    public List<IamSdkPostVo> getByOrganId(Long organId) {
        if (Objects.isNull(organId)) {
            throw new IamSdkPostException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper sysStruLambdaQueryWrapper = new LambdaQueryWrapper();
        sysStruLambdaQueryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        sysStruLambdaQueryWrapper.eq(SysStru::getOrganId, (Object)organId);
        List list = this.sysStruService.list((Wrapper)sysStruLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)list, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        LambdaQueryWrapper sysStruPostLambdaQueryWrapper = new LambdaQueryWrapper();
        Set struIds = list.stream().map(SysStru::getId).collect(Collectors.toSet());
        sysStruPostLambdaQueryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        sysStruPostLambdaQueryWrapper.in(SysStruPost::getStruId, struIds);
        List sysStruPostList = this.sysStruPostService.list((Wrapper)sysStruPostLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruPostList, (String)"\u7ec4\u7ec7\u4e0e\u5c97\u4f4d\u5173\u7cfb\u4e0d\u5b58\u5728");
        Set<Long> postIds = sysStruPostList.stream().map(SysStruPost::getPostId).collect(Collectors.toSet());
        List<SysPost> sysPostList = this.getSysPostList(postIds);
        Map<Long, IamSdkPostVo> struPostMap = this.getStruPostMap(new ArrayList<Long>(postIds));
        return this.buildIamSdkPostVoList(sysPostList, struPostMap);
    }

    private List<IamSdkPostVo> buildIamSdkPostVoList(List<SysPost> postList, Map<Long, IamSdkPostVo> struPostMap) {
        ArrayList<IamSdkPostVo> iamSdkPostVoList = new ArrayList<IamSdkPostVo>();
        if (CollectionUtils.isEmpty(postList)) {
            return iamSdkPostVoList;
        }
        postList.forEach(sysPost -> {
            IamSdkPostVo iamSdkPostVo = new IamSdkPostVo();
            BeanUtils.copyProperties((Object)sysPost, (Object)iamSdkPostVo);
            iamSdkPostVo.setPostId(sysPost.getId());
            if (MapUtils.isNotEmpty((Map)struPostMap) && struPostMap.containsKey(sysPost.getId())) {
                iamSdkPostVo.setOrganType(((IamSdkPostVo)struPostMap.get(sysPost.getId())).getOrganType());
            }
            iamSdkPostVoList.add(iamSdkPostVo);
        });
        return iamSdkPostVoList;
    }

    private List<SysPost> getSysPostList(Set<Long> postIds) {
        LambdaQueryWrapper postLambdaQueryWrapper = new LambdaQueryWrapper();
        postLambdaQueryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        postLambdaQueryWrapper.in(SysPost::getId, postIds);
        return this.hussarBasePostService.list((Wrapper)postLambdaQueryWrapper);
    }
}

