/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.controller.permission;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryFunctionDto;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkFunctionService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkFunctionModuleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkFunctionVo;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/function"})
@Api(tags={"\u529f\u80fd\u5bf9\u5916\u63a5\u53e3"})
public class HussarIamSdkFunctionController {
    @Autowired
    private IHussarIamSdkFunctionService hussarIamSdkFunctionService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u529f\u80fd\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u529f\u80fd\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u529f\u80fd\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:function:getByUserId"})
    @PostMapping(value={"/getByUserId"})
    public IamSdkApiResponse<List<IamSdkFunctionVo>> getByUserId(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkFunctionService.getByUserId(userId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:function:getByRoleId"})
    @PostMapping(value={"/getByRoleId"})
    public IamSdkApiResponse<List<IamSdkFunctionVo>> getByRoleId(@RequestBody Long roleId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkFunctionService.getByRoleId(roleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u96c6\u5408\u5173\u8054\u7684\u529f\u80fd\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u96c6\u5408\u5173\u8054\u7684\u529f\u80fd\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u96c6\u5408\u5173\u8054\u7684\u529f\u80fd\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:function:getByRoleIds"})
    @PostMapping(value={"/getByRoleIds"})
    public IamSdkApiResponse<List<IamSdkFunctionVo>> getByRoleIds(@RequestBody List<Long> roleIds) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkFunctionService.getByRoleIds(roleIds));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u529f\u80fd\u5217\u8868", notes="\u6761\u4ef6\u67e5\u8be2\u529f\u80fd\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6761\u4ef6\u67e5\u8be2\u529f\u80fd\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:function:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<IamSdkFunctionVo>> list(@RequestBody IamSdkQueryFunctionDto iamSdkQueryFunctionDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkFunctionService.list(iamSdkQueryFunctionDto));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u529f\u80fd\u5217\u8868", notes="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u529f\u80fd\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u529f\u80fd\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:function:page"})
    @PostMapping(value={"/page"})
    public IamSdkApiResponse<Page<IamSdkFunctionVo>> page(@RequestBody IamSdkQueryFunctionDto iamSdkQueryFunctionDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkFunctionService.page(iamSdkQueryFunctionDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u5217\u8868", notes="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:function:getFunctionModule"})
    @PostMapping(value={"/getFunctionModule"})
    public IamSdkApiResponse<List<IamSdkFunctionModuleVo>> getFunctionModule(@RequestBody(required=false) Long moduleId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkFunctionService.getFunctionModule(moduleId));
    }
}

