/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.controller.identity;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryStaffDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkSearchOrganDto;
import com.jxdinfo.hussar.iam.sdk.api.service.identity.IHussarIamSdkStaffService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkStaffVo;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/staff"})
@Api(tags={"\u4eba\u5458\u5bf9\u5916\u63a5\u53e3"})
public class HussarIamSdkStaffController {
    @Autowired
    private IHussarIamSdkStaffService hussarIamSdkStaffService;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5173\u8054\u7684\u4eba\u5458", notes="\u67e5\u8be2\u7528\u6237\u5173\u8054\u7684\u4eba\u5458")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u8be2\u7528\u6237\u5173\u8054\u7684\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:getByUserId"})
    @PostMapping(value={"/getByUserId"})
    public IamSdkApiResponse<IamSdkStaffVo> getByUserId(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.getByUserId(userId));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u4eba\u5458\u5217\u8868", notes="\u6761\u4ef6\u67e5\u8be2\u4eba\u5458\u5217\u8868")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6761\u4ef6\u67e5\u8be2\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<IamSdkStaffVo>> list(@RequestBody IamSdkQueryStaffDto queryStaffDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.list(queryStaffDto));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u4eba\u5458\u5217\u8868", notes="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u4eba\u5458\u5217\u8868")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:page"})
    @PostMapping(value={"/page"})
    public IamSdkApiResponse<Page<IamSdkStaffVo>> page(@RequestBody IamSdkQueryStaffDto queryStaffDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.page(queryStaffDto));
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u4eba\u5458\u5217\u8868", notes="\u5206\u9875\u83b7\u53d6\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u4eba\u5458\u5217\u8868")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u5206\u9875\u83b7\u53d6\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:getPageByOrganId"})
    @PostMapping(value={"/getPageByOrganId"})
    public IamSdkApiResponse<Page<IamSdkStaffVo>> getPageByOrganId(@RequestBody IamSdkSearchOrganDto searchOrganDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.getPageByOrganId(searchOrganDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u4eba\u5458\u5217\u8868", notes="\u83b7\u53d6\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u4eba\u5458\u5217\u8868")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:getByOrganId"})
    @PostMapping(value={"/getByOrganId"})
    public IamSdkApiResponse<List<IamSdkStaffVo>> getByOrganId(@RequestBody Long organId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.getByOrganId(organId));
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5173\u8054\u4eba\u5458\u5217\u8868", notes="\u5206\u9875\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5173\u8054\u4eba\u5458\u5217\u8868")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u5206\u9875\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5173\u8054\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:allSubStaffPage"})
    @PostMapping(value={"/allSubStaffPage"})
    public IamSdkApiResponse<Page<IamSdkStaffVo>> allSubStaffPage(@RequestBody IamSdkSearchOrganDto searchOrganDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.allSubStaffPage(searchOrganDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5173\u8054\u4eba\u5458\u5217\u8868", notes="\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5173\u8054\u4eba\u5458\u5217\u8868")
    @AuditLog(moduleName="\u4eba\u5458\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5173\u8054\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:staff:allSubStaffList"})
    @PostMapping(value={"/allSubStaffList"})
    public IamSdkApiResponse<List<IamSdkStaffVo>> allSubStaffList(@RequestBody Long organId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkStaffService.allSubStaffList(organId));
    }
}

