/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.sync;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.enums.StruRoleStatus;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.organmanager.OrganChangeNotify;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkOrganDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkPageInfo;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncStru;
import com.jxdinfo.hussar.iam.sdk.api.service.sync.IHussarIamSdkSyncOrganService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkDataMapping;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkOrganInfoVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamStruMapper;
import com.jxdinfo.hussar.iam.sdk.server.dao.sync.SyncStruMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.server.service.impl.sync.hussarIamSdkSyncOrganServiceImpl")
public class HussarIamSdkSyncOrganServiceImpl
implements IHussarIamSdkSyncOrganService {
    @Resource
    private HussarIamStruMapper hussarIamStruMapper;
    @Resource
    private SyncStruMapper syncStruMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruStaffAuditService sysStruStaffAuditService;
    @Resource
    private ISysStaffAuditService sysStaffAuditService;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private AddOrganizationManager addOrganizationManager;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private OrganChangeNotify organChangeNotify;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysStruService struService;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private ISysStruPostAuditService sysStruPostAuditService;
    @Resource
    private ISysStruStaffService sysStruStaffService;
    @Resource
    private ISysStruUserAuditService sysStruUserAuditService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysStruRoleAuditService sysStruRoleAuditService;

    public Page<IamSdkOrganInfoVo> getAllOrganInfo(IamSdkPageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)((PageInfo)JSON.parseObject((String)JSON.toJSONString((Object)pageInfo), PageInfo.class)));
        List<IamSdkOrganInfoVo> list = this.hussarIamStruMapper.getAllOrganInfo((Page<IamSdkOrganInfoVo>)page);
        page.setRecords(list);
        return page;
    }

    @HussarTransactional
    public IamSdkDataMapping addOrgan(IamSdkOrganDto organDto) {
        String organId = organDto.getOrganId();
        AssertUtil.isNotEmpty((String)organId, (String)"\u7ec4\u7ec7id\u672a\u4f20\u9012");
        String organName = organDto.getOrganName();
        AssertUtil.isNotEmpty((String)organName, (String)"\u7ec4\u7ec7\u540d\u79f0\u672a\u4f20\u9012");
        String organType = StringUtils.trimToEmpty((String)organDto.getOrganType());
        LambdaQueryWrapper typeLambdaQueryWrapper = new LambdaQueryWrapper();
        typeLambdaQueryWrapper.eq(SysOrganType::getOrganType, (Object)organType);
        boolean existType = this.sysOrganTypeService.count((Wrapper)typeLambdaQueryWrapper) > 0L;
        AssertUtil.isTrue((boolean)existType, (String)"\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
        Long count = this.syncStruMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SyncStru::getStruId, (Object)organId));
        AssertUtil.isFalse((count > 0L ? 1 : 0) != 0, (String)"\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25\uff01\u8be5\u7ec4\u7ec7\u5df2\u540c\u6b65\uff01");
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initializationAdd(organDto, sysStru, sysOrgan, sysOffice);
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
        this.sysOrganService.save((Object)sysOrgan);
        this.sysStruMapper.insert((Object)sysStru);
        this.sysOfficeService.save((Object)sysOffice);
        SyncStru syncStru = new SyncStru();
        syncStru.setStruId(organId);
        syncStru.setIamStruId(sysStru.getId());
        this.syncStruMapper.insert(syncStru);
        this.organChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStru.getId(), sysOrgan, null});
        return new IamSdkDataMapping(sysStru.getId(), organId);
    }

    private void initializationAdd(IamSdkOrganDto organDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String parentId = StringUtils.trimToEmpty((String)organDto.getParentId());
        String organCode = StringUtils.trimToEmpty((String)organDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)organDto.getOrganType());
        String organName = StringUtils.trimToEmpty((String)organDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)organDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)organDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)organDto.getShortName());
        String organDescription = StringUtils.trimToEmpty((String)organDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)organDto.getOfficeAddress());
        Long sysStruId = HussarUtils.isEmpty((Object)organDto.getOrganIdLong()) ? Long.valueOf(IdWorker.getId((Object)sysStru)) : organDto.getOrganIdLong();
        Long sysOrganId = IdWorker.getId((Object)sysOrgan);
        Long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(sysStruId);
        sysStru.setOrganId(sysOrganId);
        if (HussarUtils.isNotEmpty((Object)parentId)) {
            SyncStru syncStru = (SyncStru)this.syncStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncStru::getStruId, (Object)parentId));
            AssertUtil.isNotNull((Object)syncStru, (String)"\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25\uff01\u7236\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01");
            sysStru.setParentId(syncStru.getIamStruId());
        } else {
            sysStru.setParentId(Long.valueOf(11L));
        }
        Long userId = this.getUserId(userAccount);
        sysStru.setPrincipalId(userId);
        sysStru.setStruType(organType);
        sysStru.setOrganAlias(organAlias);
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById((Serializable)sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        int orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(sysOfficeId);
        sysOffice.setStruId(sysStruId);
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        sysOrgan.setId(sysOrganId);
        if (HussarUtils.isEmpty((Object)organCode)) {
            String code = this.getCode();
            sysOrgan.setOrganCode(code);
        } else {
            sysOrgan.setOrganCode(organCode);
        }
        sysOrgan.setOrganName(organName);
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : organShortName);
        sysOrgan.setOrganType(organType);
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)organAlias) ? sysOrgan.getOrganName() : organAlias);
        sysStru.setIsLeaf("Y");
    }

    private Long getUserId(String userAccount) {
        if (HussarUtils.isBlank((CharSequence)userAccount)) {
            return null;
        }
        String userAccountTemp = userAccount;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            userAccountTemp = userAccountTemp.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccountTemp)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()));
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        return sysUsers.getId();
    }

    @HussarTransactional
    public Boolean editOrgan(IamSdkOrganDto organDto) {
        String organId = organDto.getOrganId();
        SyncStru syncStru = (SyncStru)this.syncStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncStru::getStruId, (Object)organId));
        AssertUtil.isNotNull((Object)syncStru, (String)"\u540c\u6b65\u4fee\u6539\u7ec4\u7ec7\u5931\u8d25\uff01\u8be5\u7ec4\u7ec7\u672a\u540c\u6b65\uff01");
        Long struId = syncStru.getIamStruId();
        SysStru stru = (SysStru)this.sysStruMapper.selectById((Serializable)struId);
        AssertUtil.isNotNull((Object)stru, (String)"\u540c\u6b65\u4fee\u6539\u7ec4\u7ec7\u5931\u8d25\uff01\u8be5\u7ec4\u7ec7\u672a\u540c\u6b65\uff01");
        SysOrgan sysOrganTemp = (SysOrgan)this.sysOrganService.getById((Serializable)stru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrganTemp, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        BeanUtils.copyProperties((Object)sysOrganTemp, (Object)sysOrgan);
        this.initializationEdit(organDto, stru, sysOrgan, sysOffice);
        this.sysStruMapper.updateById((Object)stru);
        this.sysOrganService.updateById((Object)sysOrgan);
        if (HussarUtils.isNotEmpty((Object)sysOffice)) {
            this.sysOfficeService.updateById((Object)sysOffice);
        }
        this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{stru.getId(), sysOrgan, null});
        return Boolean.TRUE;
    }

    private void initializationEdit(IamSdkOrganDto organDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)organDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)organDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)organDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)organDto.getShortName());
        String organDescription = StringUtils.trimToEmpty((String)organDto.getOrganDescription());
        String organAddress = organDto.getOfficeAddress();
        String currentFname = sysOrgan.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + organDto.getOrganName().trim();
        if (!Objects.equals(organDto.getOrganName().trim(), sysOrgan.getOrganName())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode());
            wrapper.ne(SysOrgan::getId, (Object)sysOrgan.getId());
            List sysOrgans = this.sysOrganService.list((Wrapper)wrapper);
            for (SysOrgan temp : sysOrgans) {
                temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
            }
            this.sysOrganService.updateBatchById((Collection)sysOrgans);
        }
        Long struId = sysStru.getId();
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        if (StringUtils.isNotBlank((CharSequence)organAlias)) {
            sysStru.setOrganAlias(organAlias);
        }
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        if (StringUtils.isNotBlank((CharSequence)organShortName)) {
            sysOrgan.setShortName(organShortName);
        }
        if (StringUtils.isNotBlank((CharSequence)organAddress)) {
            sysOffice.setOfficeAddress(organAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)organDescription)) {
            sysOffice.setOfficeAlias(organDescription);
        }
    }

    private String getCode() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        String currentCode = "";
        long currentCount = 1L;
        long num = 0L;
        String firstCode = "";
        while (currentCount != 0L) {
            lambdaQueryWrapper.clear();
            currentCode = this.sysIdtableService.getCurrentCode("ORGAN_CODE_4", "SYS_ORGAN");
            if (++num == 1L) {
                firstCode = currentCode;
            }
            AssertUtil.isFalse((num > 1L && currentCode.equals(firstCode) ? 1 : 0) != 0, (String)"\u540c\u6b65\u7ec4\u7ec7\u5931\u8d25\uff01\u65e0\u53ef\u7528\u7f16\u7801\uff01");
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)currentCode);
            currentCount = this.sysOrganService.count((Wrapper)lambdaQueryWrapper);
        }
        return currentCode;
    }

    @HussarTransactional
    public Boolean deleteOrgan(String syncStruId) {
        SyncStru syncStru = (SyncStru)this.syncStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncStru::getStruId, (Object)syncStruId));
        if (HussarUtils.isNotEmpty((Object)syncStru)) {
            Long struId = syncStru.getIamStruId();
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById((Serializable)struId);
            if (HussarUtils.isEmpty((Object)sysStru)) {
                this.syncStruMapper.deleteById(syncStru.getId());
                return Boolean.TRUE;
            }
            int struLevel = sysStru.getStruLevel();
            Long parentId = sysStru.getParentId();
            Long organId = sysStru.getOrganId();
            SysOrgan sysOrgan = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getId, (Object)organId)).ne(SysOrgan::getOrganType, (Object)"9"));
            List strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            List<Long> struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            this.deleteStruRelation(struIds);
            this.organService.remove((Wrapper)new LambdaQueryWrapper().likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode()));
            String struFid = sysStru.getStruFid();
            this.sysOfficeMapper.deleteBatchByStruFid(struFid);
            this.sysStruMapper.delete((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            if (struLevel > 1) {
                SysStru parentSysStru = (SysStru)this.struService.getById((Serializable)parentId);
                long count = this.struService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getId, (Object)sysStru.getId()));
                parentSysStru.setIsLeaf(count > 0L ? "N" : "Y");
                this.sysStruMapper.updateById((Object)parentSysStru);
            }
            LambdaQueryWrapper postWrapper = LambdaQueryUtil.getMultiQueryWrapper(SyncStru::getIamStruId, struIds);
            this.syncStruMapper.delete((Wrapper)postWrapper);
            this.organChangeNotify.notify(DataChangeType.DELETE, new Object[]{struId, sysOrgan, null});
        }
        return Boolean.TRUE;
    }

    private void deleteStruRelation(List<Long> struIds) {
        LambdaQueryWrapper postWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruPost::getStruId, struIds);
        this.sysStruPostService.remove((Wrapper)postWrapper);
        LambdaQueryWrapper postAuditWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruPostAudit::getStruId, struIds);
        this.sysStruPostAuditService.remove((Wrapper)postAuditWrapper.eq(SysStruPostAudit::getAuditStatus, (Object)"0"));
        this.handleStruStaffAudit(struIds);
        LambdaQueryWrapper staffWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruStaff::getStruId, struIds);
        this.sysStruStaffService.remove((Wrapper)staffWrapper);
        LambdaQueryWrapper staffAuditWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruStaffAudit::getStruId, struIds);
        this.sysStruStaffAuditService.remove((Wrapper)staffAuditWrapper.eq(SysStruStaffAudit::getAuditStatus, (Object)"0"));
        LambdaQueryWrapper userAuditWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruUserAudit::getStruId, struIds);
        this.sysStruUserAuditService.remove((Wrapper)userAuditWrapper.eq(SysStruUserAudit::getAuditStatus, (Object)"0"));
        LambdaQueryWrapper userWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruUser::getStruId, struIds);
        this.sysStruUserService.remove((Wrapper)userWrapper);
        LambdaQueryWrapper roleWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruRole::getStruId, struIds);
        this.sysStruRoleService.remove((Wrapper)roleWrapper);
        LambdaQueryWrapper roleAuditWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruRoleAudit::getStruId, struIds);
        roleAuditWrapper.eq(SysStruRoleAudit::getStatus, (Object)StruRoleStatus.LOCKED.getCode());
        this.sysStruRoleAuditService.remove((Wrapper)roleAuditWrapper);
    }

    private void handleStruStaffAudit(List<Long> struIds) {
        List struStaffAudits = this.sysStruStaffAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getAuditStatus, (Object)"0"));
        if (HussarUtils.isEmpty((Object)struStaffAudits)) {
            return;
        }
        Map<Long, List<SysStruStaffAudit>> map = struStaffAudits.stream().collect(Collectors.groupingBy(SysStruStaffAudit::getStaffId));
        ArrayList staffIds = new ArrayList();
        map.forEach((key, value) -> {
            if (value.size() == 1 && struIds.contains(((SysStruStaffAudit)value.get(0)).getStruId())) {
                staffIds.add(key);
            }
        });
        if (HussarUtils.isNotEmpty(staffIds)) {
            this.sysStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().in(SysStaffAudit::getRealStaffId, staffIds));
        }
    }
}

