/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.controller.account;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkLoginDTO;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryUserDto;
import com.jxdinfo.hussar.iam.sdk.api.service.account.IHussarIamSdkUserService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserVO;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/user"})
@Api(tags={"\u7528\u6237\u4fe1\u606f\u5bf9\u5916\u63a5\u53e3"})
public class HussarIamSdkUserController {
    @Resource
    private IHussarIamSdkUserService iamSdkUserService;

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u5bc6\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u540d\u5bc6\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u6839\u636e\u7528\u6237\u540d\u5bc6\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f", eventDesc="\u6839\u636e\u7528\u6237\u540d\u5bc6\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:login"})
    @PostMapping(value={"/login"})
    public IamSdkApiResponse<IamSdkUserVO> login(@RequestBody IamSdkLoginDTO loginDTO) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.login(loginDTO));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u5217\u8868", eventDesc="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:getByRoleId"})
    @PostMapping(value={"/getByRoleId"})
    public IamSdkApiResponse<List<IamSdkUserVO>> getByRoleId(@RequestBody Long roleId) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.getByRoleId(roleId));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)", notes="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)")
    @AuditLog(moduleName="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)", eventDesc="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<IamSdkUserVO>> list(@RequestBody IamSdkQueryUserDto queryUserDTO) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.list(queryUserDTO));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)", notes="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)")
    @AuditLog(moduleName="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)", eventDesc="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7528\u6237)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:page"})
    @PostMapping(value={"/page"})
    public IamSdkApiResponse<Page<IamSdkUserVO>> page(@RequestBody IamSdkQueryUserDto queryUserDTO) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.page(queryUserDTO));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)", notes="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)")
    @AuditLog(moduleName="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)", eventDesc="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:listByOrgan"})
    @PostMapping(value={"/listByOrgan"})
    public IamSdkApiResponse<List<IamSdkUserVO>> listByOrgan(@RequestBody IamSdkQueryUserDto queryUserDTO) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.listByOrgan(queryUserDTO));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)", notes="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)")
    @AuditLog(moduleName="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)", eventDesc="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868(\u7ec4\u7ec7\u53ca\u5176\u5b50\u7ec4\u7ec7\u4e0b\u7528\u6237)", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:pageByOrgan"})
    @PostMapping(value={"/pageByOrgan"})
    public IamSdkApiResponse<Page<IamSdkUserVO>> pageByOrgan(@RequestBody IamSdkQueryUserDto queryUserDTO) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.pageByOrgan(queryUserDTO));
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5217\u8868", notes="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5217\u8868")
    @AuditLog(moduleName="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5217\u8868", eventDesc="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:getByIds"})
    @PostMapping(value={"/getByIds"})
    public IamSdkApiResponse<List<IamSdkUserVO>> getByIds(@RequestBody List<Long> userIds) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.getByIds(userIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237\u5217\u8868", notes="\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237\u5217\u8868", eventDesc="\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:user:getByPostId"})
    @PostMapping(value={"/getByPostId"})
    public IamSdkApiResponse<List<IamSdkUserVO>> getByPostId(@RequestBody Long postId) {
        return IamSdkApiResponse.success((Object)this.iamSdkUserService.getByPostId(postId));
    }
}

