/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.http.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class SpringContextUtil
implements ApplicationContextAware,
EnvironmentAware {
    private static Logger LOGGER = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext applicationContext = null;
    private static Environment environment = null;
    private static final Map<String, Object> CACHE_MAP = new HashMap<String, Object>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        LOGGER.info("------SpringContextHolder setApplicationContext-------");
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static void setStaticApplicationContext(ApplicationContext applicationContext) throws BeansException {
        LOGGER.info("------SpringContextHolder setApplicationContext-------");
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(String name) throws BeansException {
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) throws BeansException {
        return SpringContextUtil.getBean(clazz, false);
    }

    public static <T> T getBeanTarget(Class<T> clazz) {
        return SpringContextUtil.getBeanTarget(clazz, false);
    }

    public static <T> T getBean(Class<T> clazz, boolean printError) throws BeansException {
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            if (printError) {
                LOGGER.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
            }
            return null;
        }
    }

    public static <T> T getBeanTarget(Class<T> clazz, boolean printError) throws BeansException {
        try {
            return (T)SpringContextUtil.getTarget(applicationContext.getBean(clazz));
        }
        catch (Exception e) {
            if (printError) {
                LOGGER.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
            }
            return null;
        }
    }

    public static <T> T getBeanByClass(Class<T> clazz) throws BeansException {
        return SpringContextUtil.getBean(clazz, false);
    }

    public static <T> T getBeanTargetByClass(Class<T> clazz) throws BeansException {
        return SpringContextUtil.getBeanTarget(clazz, false);
    }

    public static <T> List<T> getBeansByClass(Class<T> clazz) {
        String[] names = SpringContextUtil.getApplicationContext().getBeanNamesForType(clazz);
        ArrayList<T> result = new ArrayList<T>();
        for (String name : names) {
            result.add(SpringContextUtil.getBean(name));
        }
        return result;
    }

    public static <T> T getBeanByClassForApi(Class<T> clazz) {
        String[] names = SpringContextUtil.getApplicationContext().getBeanNamesForType(clazz);
        T resultBean = null;
        String serviceName = clazz.getName();
        if (names.length > 1) {
            for (String name : names) {
                if (name.equals(serviceName)) continue;
                resultBean = SpringContextUtil.getBean(name);
                break;
            }
        }
        if (resultBean == null) {
            resultBean = SpringContextUtil.getBean(serviceName);
        }
        return resultBean;
    }

    public static Object getTarget(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            try {
                proxy = SpringContextUtil.getJdkDynamicProxyTargetObject(proxy);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
                return proxy;
            }
        }
        try {
            proxy = SpringContextUtil.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
            return proxy;
        }
        return SpringContextUtil.getTarget(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    public static <T> T getBeanByClass(Class<T> clazz, String[] actualTypeArguments) {
        StringBuilder sBuilder = new StringBuilder();
        String cacheKey = null;
        for (String actualTypeArgument : actualTypeArguments) {
            sBuilder.append("_" + actualTypeArgument);
        }
        cacheKey = clazz.getName() + sBuilder.toString();
        if (CACHE_MAP.containsKey(cacheKey)) {
            return (T)CACHE_MAP.get(cacheKey);
        }
        String[] candidateNames = applicationContext.getBeanNamesForType(clazz);
        Object object = null;
        Type[] types = null;
        for (String candidateName : candidateNames) {
            object = SpringContextUtil.getBean(candidateName);
            types = object.getClass().getName().contains("EnhancerBySpringCGLIB") ? ((ParameterizedType)object.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments() : ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments();
            boolean isThisObj = true;
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (actualTypeArguments[i].equals(types[i].getTypeName())) continue;
                isThisObj = false;
                break;
            }
            if (!isThisObj) continue;
            CACHE_MAP.put(cacheKey, object);
            return (T)object;
        }
        return null;
    }

    public static <T> T getBeanByClass(Class<T> clazz, String actualTypeArgument, int index) {
        String[] candidateNames = applicationContext.getBeanNamesForType(clazz);
        Object object = null;
        Type[] types = null;
        for (String candidateName : candidateNames) {
            object = SpringContextUtil.getBean(candidateName);
            types = object.getClass().getName().contains("EnhancerBySpringCGLIB") ? ((ParameterizedType)object.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments() : ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments();
            if (!actualTypeArgument.equals(types[index].getTypeName())) continue;
            return (T)object;
        }
        return null;
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return applicationContext.isSingleton(name);
    }

    public static void publishEvent(ApplicationEvent event) {
        if (applicationContext == null) {
            return;
        }
        applicationContext.publishEvent(event);
    }

    public void setEnvironment(Environment environment) {
        SpringContextUtil.environment = environment;
    }

    public static Environment getEnvironment() {
        return environment;
    }
}

