/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.http.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkTokenException;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.sdk.http.properties.IamSdkProperties;
import com.jxdinfo.hussar.iam.sdk.http.utils.HttpClientUtil;
import com.jxdinfo.hussar.iam.sdk.http.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.Map;
import javax.annotation.Resource;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.http.service.sdkTokenService")
public class SdkTokenService {
    protected static Logger logger = LoggerFactory.getLogger(SdkTokenService.class);
    @Resource
    private IamSdkProperties properties;

    public String getToken() {
        String clientId = this.properties.getClientId();
        String clientSecret = this.properties.getClientSecret();
        if (StringUtil.isEmpty((Object)clientId) || StringUtil.isEmpty((Object)clientSecret)) {
            throw new IamSdkTokenException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u8bf7\u6c42\u5931\u8d25:\u7f3a\u5c11\u53c2\u6570clientId\u6216\u8005clientSecret");
        }
        String token = (String)HussarCacheUtil.get((String)"iam_client_token", (Object)clientId);
        if (!StringUtil.isEmpty((Object)token)) {
            return token;
        }
        try {
            String getTokenUrl = this.properties.getIamServer() + SdkUrlEnum.GET_TOKEN.getUrl();
            Request request = new Request.Builder().url(getTokenUrl).addHeader("Client-Id", clientId).addHeader("client-secret", clientSecret).build();
            Response response = HttpClientUtil.getClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IamSdkTokenException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u8bf7\u6c42\u5931\u8d25:" + response.message());
            }
            String resultStr = response.body().string();
            IamSdkApiResponse<Map<String, Object>> tokenResponse = JsonUtil.parse(resultStr, new TypeReference<IamSdkApiResponse<Map<String, Object>>>(){});
            if (tokenResponse == null || !tokenResponse.isSuccess()) {
                throw new IamSdkTokenException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u5931\u8d25:" + resultStr);
            }
            Map tokenMap = (Map)tokenResponse.getData();
            token = (String)tokenMap.get("client-token");
            long expiresIn = Long.parseLong(tokenMap.get("expires-in").toString());
            long thisExpiresIn = expiresIn - this.properties.getRefreshTokenTime() * 60L;
            if (thisExpiresIn > 0L) {
                HussarCacheUtil.put((String)"iam_client_token", (Object)this.properties.getClientId(), (Object)token, (long)thisExpiresIn);
            }
            return token;
        }
        catch (Exception e) {
            throw new IamSdkTokenException("\u8c03\u7528sdk\u63a5\u53e3\u65f6\uff0c\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
        }
    }
}

