/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseFunctionDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.RoleFunctionChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RoleFunctionChangeNotify
extends AbstractDataChangeNotify<RoleFunctionChangeDto> {
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysRoleFunctionsService roleFunctionsService;

    public RoleFunctionChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        Long roleId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)roleId)) {
            return null;
        }
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        if (HussarUtils.isEmpty((Object)role)) {
            return null;
        }
        RoleFunctionChangeDto roleFunctionChangeDTO = new RoleFunctionChangeDto();
        roleFunctionChangeDTO.setRoleId(roleId);
        roleFunctionChangeDTO.setRoleCode(String.valueOf(role.getId()));
        List functionIds = (List)args[1];
        if (HussarUtils.isNotEmpty((Object)functionIds)) {
            List<BaseFunctionDto> baseFunctionDtoList = this.getBaseFunction(functionIds);
            roleFunctionChangeDTO.setFunctions(baseFunctionDtoList);
        } else {
            List roleFunctions = this.roleFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)roleId));
            List<Long> functionIdList = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(functionIdList)) {
                List<BaseFunctionDto> baseFunctionDtoList = this.getBaseFunction(functionIdList);
                roleFunctionChangeDTO.setFunctions(baseFunctionDtoList);
            }
        }
        return roleFunctionChangeDTO;
    }

    public String getApplicationCode(Object ... args) {
        Long roleId = (Long)args[0];
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)role.getAppId());
        return application.getAppCode();
    }

    public NotifyType getNotifyType() {
        return NotifyType.ROLE_FUNCTION_CHANGE;
    }

    private List<BaseFunctionDto> getBaseFunction(List<Long> functionIds) {
        ArrayList<BaseFunctionDto> baseFunctionDtoList = new ArrayList<BaseFunctionDto>();
        this.sysFunctionsService.listByIds(functionIds).forEach(sysFunctions -> {
            BaseFunctionDto baseFunctionDTO = new BaseFunctionDto();
            baseFunctionDTO.setFunctionId(sysFunctions.getId());
            baseFunctionDTO.setFunctionCode(sysFunctions.getFunctionCode());
            baseFunctionDtoList.add(baseFunctionDTO);
        });
        return baseFunctionDtoList;
    }
}

