/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.ResourceChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.ResourceExpandDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ResourceChangeNotify
extends AbstractDataChangeNotify<ResourceChangeDto> {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;
    @Resource
    private ISysResourcesService sysResourcesService;

    public String getApplicationCode(Object ... args) {
        SysResources resource = (SysResources)args[0];
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)resource.getApplicationId());
        return application.getAppCode();
    }

    public ResourceChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysResources resource = (SysResources)args[0];
        if (HussarUtils.isEmpty((Object)resource)) {
            return null;
        }
        ResourceChangeDto resourceChangeDto = new ResourceChangeDto();
        resourceChangeDto.setResourceId(resource.getId());
        resourceChangeDto.setResourceCode(resource.getResourceCode());
        if (!DataChangeType.DELETE.equals((Object)dataChangeType)) {
            resourceChangeDto.setResourceName(resource.getResourceName());
            resourceChangeDto.setComponent(resource.getComponent());
            resourceChangeDto.setDeptRights(resource.getDeptRight());
            resourceChangeDto.setMapper(resource.getMapper());
            resourceChangeDto.setPath(resource.getPath());
            resourceChangeDto.setPermissions(resource.getPermissions());
            resourceChangeDto.setResourceType(resource.getResTypeId());
            resourceChangeDto.setUrlNames(resource.getUrlNames());
            resourceChangeDto.setUserRights(resource.getUserRight());
            resourceChangeDto.setStrategy(resource.getStrategy());
            resourceChangeDto.setSeq(resource.getSeq());
            resourceChangeDto.setServiceName(resource.getServiceName());
            resourceChangeDto.setParentModuleId(resource.getModuleId());
            resourceChangeDto.setKeepAlive(resource.getKeepAlive());
            SysResourceModules resourceModule = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)resource.getModuleId());
            resourceChangeDto.setModuleCode(resourceModule.getModuleCode());
            Long parentResourceId = resource.getParentResourceId();
            if (HussarUtils.isNotEmpty((Object)parentResourceId)) {
                SysResources parentRes = (SysResources)this.sysResourcesService.getById((Serializable)parentResourceId);
                resourceChangeDto.setParentResourceCode(parentRes.getResourceCode());
            }
            List resourceExpands = this.hussarBaseResourceExpandService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)resource.getId()));
            ArrayList<ResourceExpandDto> expandDtos = new ArrayList<ResourceExpandDto>();
            if (HussarUtils.isNotEmpty((Object)resourceExpands)) {
                for (SysResourceExpand resourceExpand : resourceExpands) {
                    ResourceExpandDto expandDto = new ResourceExpandDto();
                    expandDto.setExpandId(resourceExpand.getId());
                    expandDto.setExpandCode(resourceExpand.getResourceTypeExpandCode());
                    expandDto.setExpandName(resourceExpand.getResourceTypeExpandName());
                    expandDto.setExpandValue(resourceExpand.getResourceTypeExpandValue());
                    expandDtos.add(expandDto);
                }
            }
            resourceChangeDto.setExpandDtos(expandDtos);
        }
        return resourceChangeDto;
    }

    public NotifyType getNotifyType() {
        return NotifyType.RESOURCE_CHANGE;
    }
}

