/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.rabbit.service.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.MqProducerCreator;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.MqType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqProducerCreator
implements MqProducerCreator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RabbitAdmin rabbitAdmin;

    public void create(SysApplication app) {
        if (app == null || HussarUtils.isEmpty((Object)app.getAppCode())) {
            this.logger.error("mq\u7c7b\u578b:{}, \u5e94\u7528\u4fe1\u606f\u6216appCode\u4e3a\u7a7a, \u65e0\u6cd5\u521b\u5efa\u4e3a\u5e94\u7528\u521b\u5efa\u6d88\u606f\u961f\u5217", (Object)this.mqType().getCode());
            return;
        }
        if ("1".equals(app.getAppCode())) {
            return;
        }
        try {
            String topic = "hussar.iam.data.change_" + app.getAppCode();
            String dlxTopic = "hussar.iam.data.change.dlx_" + app.getAppCode();
            String dlxExchange = "hussar.iam.data.change.dlx.exchange_" + app.getAppCode();
            String dlxRoutingKey = "hussar.iam.data.change.dlx.routing.key_" + app.getAppCode();
            DirectExchange directExchange = new DirectExchange(dlxExchange, true, false);
            this.rabbitAdmin().declareExchange((Exchange)directExchange);
            Queue dlxQueue = QueueBuilder.durable((String)dlxTopic).build();
            this.rabbitAdmin().declareQueue(dlxQueue);
            Binding binding = BindingBuilder.bind((Queue)dlxQueue).to(directExchange).with(dlxRoutingKey);
            this.rabbitAdmin().declareBinding(binding);
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put("x-single-active-consumer", true);
            arguments.put("x-dead-letter-exchange", dlxExchange);
            arguments.put("x-dead-letter-routing-key", dlxRoutingKey);
            Queue queue = new Queue(topic, true, false, false, arguments);
            this.rabbitAdmin().declareQueue(queue);
        }
        catch (Exception e) {
            this.logger.error("mq\u7c7b\u578b:{}, \u521b\u5efa\u5e94\u7528: {}-{}\u6d88\u606f\u961f\u5217\u5931\u8d25", new Object[]{this.mqType().getCode(), app.getId(), app.getAppName(), e});
        }
    }

    public MqType mqType() {
        return MqType.RABBIT;
    }

    private RabbitAdmin rabbitAdmin() {
        if (this.rabbitAdmin == null) {
            this.rabbitAdmin = (RabbitAdmin)SpringContextUtil.getBean(RabbitAdmin.class);
        }
        return this.rabbitAdmin;
    }
}

