/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.api.service;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.iam.data.change.notify.api.properties.DataChangeNotifyProperties;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.MessageSender;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataChangeNotify<T extends BaseChangeDto> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private List<MessageSender> messageSenders;
    @Resource
    private DataChangeNotifyProperties properties;

    public void notify(DataChangeType changeType, Object ... args) {
        if (!this.properties.getEnable().booleanValue()) {
            return;
        }
        this.doNotify(changeType, args);
    }

    private void doNotify(DataChangeType changeType, Object ... args) {
        T message = this.convert(changeType, args);
        if (message == null) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u6570\u636e\u53d8\u66f4\u901a\u77e5\u6d88\u606f\u4f53, \u901a\u77e5\u7c7b\u578b\uff1a{}, \u6570\u636e\u53d8\u66f4\u7c7b\u578b: {}\uff0c\u5165\u53c2\u4e3a:{}", new Object[]{this.getNotifyType().getDesc(), changeType, JsonUtil.toJson((Object)args)});
            return;
        }
        if (HussarUtils.isEmpty((Object)message.getNotifyType())) {
            message.setNotifyType(this.getNotifyType());
        }
        if (HussarUtils.isEmpty((Object)message.getChangeType())) {
            message.setChangeType(changeType);
        }
        List<Object> appCodes = NotifyType.COMMON_NOTIFY_TYPES.contains(this.getNotifyType()) ? this.applicationService.list().stream().filter(app -> HussarUtils.isNotEmpty((Object)app.getAppCode()) && !"1".equals(app.getAppCode())).map(SysApplication::getAppCode).collect(Collectors.toList()) : Lists.newArrayList((Object[])new String[]{this.getApplicationCode(args)});
        ArrayList receiverAppCodes = new ArrayList(appCodes);
        this.messageSenders.forEach(messageSender -> {
            try {
                if (this.properties.getMqTypes().contains(messageSender.mqType().getCode())) {
                    receiverAppCodes.forEach(appCode -> {
                        String topic = this.getTopic((String)appCode);
                        messageSender.send(topic, message);
                        if (this.properties.getOpenLog().booleanValue()) {
                            this.logger.info("\u53d1\u9001\u6570\u636e\u53d8\u66f4\u901a\u77e5, mq\u7c7b\u578b:{}, \u6570\u636e\u7c7b\u578b:{}\uff0ctopic:{}, \u6d88\u606f\u4f53:{}", new Object[]{messageSender.mqType().getCode(), this.getNotifyType().getDesc(), topic, JsonUtil.toJson((Object)message)});
                        }
                    });
                }
            }
            catch (Exception e) {
                this.logger.error("mq\u7c7b\u578b:{}, \u6570\u636e\u53d8\u66f4\u6d88\u606f\u53d1\u9001\u5931\u8d25, \u901a\u77e5\u7c7b\u578b:{}\uff0c\u6570\u636e\u53d8\u66f4\u7c7b\u578b:{}", new Object[]{messageSender.mqType().getCode(), this.getNotifyType().getDesc(), changeType, e});
            }
        });
    }

    public String getApplicationCode(Object ... args) {
        return "";
    }

    public abstract T convert(DataChangeType var1, Object ... var2);

    public abstract NotifyType getNotifyType();

    private String getTopic(String appCode) {
        return "hussar.iam.data.change_" + appCode;
    }
}

