/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.common.server.runner;

import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.base.sdk.server.handler.clientApplicationRelationService")
public class ClientApplicationRelationService {
    @Resource
    private ISysAppClientService sysAppClientService;
    @Resource
    private ISysClientModelService sysClientModelService;

    public Map<String, Long> generateClientApplicationRelationMap() {
        HashMap<String, Long> clientIdToAppIdMap = new HashMap<String, Long>();
        Map<Long, Long> clientModelIdToAppIdMap = this.sysAppClientService.list().stream().collect(Collectors.toMap(SysAppClient::getClientModelId, SysAppClient::getAppId, (o1, o2) -> o2));
        if (HussarUtils.isNotEmpty(clientModelIdToAppIdMap)) {
            Map clientModelMap = this.sysClientModelService.listByIds(clientModelIdToAppIdMap.keySet()).stream().collect(Collectors.toMap(SysClientModel::getId, Function.identity()));
            clientModelIdToAppIdMap.forEach((k, v) -> {
                if (clientModelMap.containsKey(k)) {
                    clientIdToAppIdMap.put(((SysClientModel)clientModelMap.get(k)).getClientId(), (Long)v);
                }
            });
            HussarCacheUtil.put((String)"iam_sdk", (Object)"clientId_appId_map", clientIdToAppIdMap);
        }
        return clientIdToAppIdMap;
    }
}

