/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.iam.client.vo.ClientInfoVo;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/hussarBase/client"})
public class SysClientController {
    @Resource
    private IHussarIamClientModelService clientModelService;

    @ApiOperation(value="\u5ba2\u6237\u7aef\u5217\u8868\u63a5\u53e3", notes="\u5ba2\u6237\u7aef\u5217\u8868\u63a5\u53e3")
    @GetMapping(value={"/list"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u5217\u8868\u63a5\u53e3", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<ClientVo>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u5ba2\u6237\u7aefID") @RequestParam(value="clientId") String clientId, @ApiParam(value="\u5e94\u7528ID") @RequestParam(value="appId") Long appId) {
        return this.clientModelService.selectClientModelList(pageInfo, clientId, appId);
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u65b0\u589e\u4fdd\u5b58", notes="\u5ba2\u6237\u7aef\u65b0\u589e\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u65b0\u589e\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:client:save"})
    public ApiResponse<ClientVo> save(@ApiParam(value="\u5ba2\u6237\u7aefDTO") @RequestBody ClientDto clientDto) throws Exception {
        return this.clientModelService.saveClientModels(clientDto);
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u4fee\u6539\u4fdd\u5b58", notes="\u5ba2\u6237\u7aef\u4fee\u6539\u4fdd\u5b58")
    @PostMapping(value={"/update"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u4fee\u6539\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:client:update"})
    public ApiResponse<Boolean> update(@ApiParam(value="\u5ba2\u6237\u7aefDTO") @RequestBody ClientDto clientDto) {
        return this.clientModelService.updateClientModels(clientDto);
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u5220\u9664", notes="\u5ba2\u6237\u7aef\u5220\u9664")
    @PostMapping(value={"/delete"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"hussarBase:client:delete"})
    public ApiResponse<Boolean> delete(@ApiParam(value="\u5ba2\u6237\u7aefID") @RequestBody String clientId) {
        return this.clientModelService.deleteClientModel(clientId);
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u4fe1\u606f\u63a5\u53e3", notes="\u5ba2\u6237\u7aef\u4fe1\u606f\u63a5\u53e3")
    @GetMapping(value={"/clientInfo"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u4fe1\u606f\u63a5\u53e3", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ClientInfoVo> clientInfo() {
        return this.clientModelService.getClientInfo();
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u66f4\u65b0\u5bc6\u94a5", notes="\u5ba2\u6237\u7aef\u66f4\u65b0\u5bc6\u94a5")
    @PostMapping(value={"/updateClientSecret"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u4fe1\u606f\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u66f4\u65b0\u5bc6\u94a5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateClientSecret(@ApiParam(value="\u5ba2\u6237\u7aefid") @RequestBody Long id) {
        return this.clientModelService.updateClientSecret(id);
    }
}

