/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ILocalClientPermissionService;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.support.apimanager.core.support.model.ScopePermissionModel;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalClientPermissionServiceImpl
implements ILocalClientPermissionService {
    @Autowired
    private ISysClientModelService sysClientModelService;
    @Autowired
    private ISysClientPermissionService sysClientPermissionService;
    @Autowired
    private ISysResourcesService sysResourcesService;

    public List<String> getPermissionList(ScopePermissionModel scopePermissionModel) {
        String scope = scopePermissionModel.getScope();
        String clientId = scopePermissionModel.getClientId();
        ArrayList<String> permissionList = new ArrayList<String>();
        ArrayList<String> scopeList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)scope)) {
            String[] scopes;
            for (String single : scopes = scope.split(",")) {
                if (!ToolUtil.isNotEmpty((Object)single)) continue;
                scopeList.add(single);
            }
        }
        if (ToolUtil.isEmpty(scopeList)) {
            scopeList.add("permission_list");
        }
        if (ToolUtil.isNotEmpty((Object)clientId)) {
            this.checkClientModel(clientId);
            List clientPermissionList = this.sysClientPermissionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysClientPermission::getClientId, (Object)clientId)).in(SysClientPermission::getScope, scopeList));
            ArrayList permissionIdList = new ArrayList();
            clientPermissionList.forEach(cp -> permissionIdList.add(cp.getPermissionId()));
            if (ToolUtil.isNotEmpty(permissionIdList)) {
                List idList = permissionIdList.stream().distinct().collect(Collectors.toList());
                List resourcesList = this.sysResourcesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysResources::getId, idList)).eq(SysResources::getResTypeId, (Object)"res_open_interface")).and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                }));
                resourcesList.forEach(r -> {
                    if (ToolUtil.isNotEmpty((Object)r.getUrlNames())) {
                        permissionList.add(r.getUrlNames());
                    }
                });
            }
        }
        return permissionList;
    }

    private void checkClientModel(String clientId) {
        SysClientModel clientModel = (SysClientModel)this.sysClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysClientModel::getClientId, (Object)clientId));
        if (ToolUtil.isEmpty((Object)clientModel)) {
            throw new BaseException("\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728");
        }
        if ("0".equals(clientModel.getClientStatus())) {
            throw new BaseException("\u5ba2\u6237\u7aef\u5df2\u7981\u7528");
        }
    }
}

