/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.controller;

import com.jxdinfo.hussar.iam.client.dto.ClientPermissionDto;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientPermissionService;
import com.jxdinfo.hussar.iam.client.vo.ClientPermissionVo;
import com.jxdinfo.hussar.iam.client.vo.OpenResTreeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u7aef\u8d44\u6e90\u5173\u8054\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/hussarBase/client/permission"})
public class SysClientPermissionController {
    @Resource
    private IHussarIamClientPermissionService clientPermissionService;

    @ApiOperation(value="\u83b7\u53d6\u5f00\u653e\u63a5\u53e3\u8d44\u6e90", notes="\u83b7\u53d6\u5f00\u653e\u63a5\u53e3\u8d44\u6e90")
    @GetMapping(value={"/openResTree"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u8d44\u6e90\u5173\u8054\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5f00\u653e\u63a5\u53e3\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OpenResTreeVo>> openResTree(@ApiParam(value="\u5e94\u7528ID") @RequestParam(value="appId") Long appId) {
        return this.clientPermissionService.openResTree(appId);
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u6388\u6743\u8d44\u6e90\u4fdd\u5b58\u63a5\u53e3", notes="\u5ba2\u6237\u7aef\u6388\u6743\u8d44\u6e90\u4fdd\u5b58\u63a5\u53e3")
    @PostMapping(value={"/save"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u8d44\u6e90\u5173\u8054\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u6388\u6743\u8d44\u6e90\u4fdd\u5b58\u63a5\u53e3", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> save(@ApiParam(value="\u5ba2\u6237\u7aef\u6388\u6743\u8d44\u6e90DTO") @RequestBody List<ClientPermissionDto> list) {
        return this.clientPermissionService.saveClientPermissionBatch(list);
    }

    @ApiOperation(value="\u5ba2\u6237\u7aef\u5df2\u6388\u6743\u8d44\u6e90", notes="\u5ba2\u6237\u7aef\u5df2\u6388\u6743\u8d44\u6e90")
    @GetMapping(value={"/list"})
    @AuditLog(moduleName="\u5ba2\u6237\u7aef\u8d44\u6e90\u5173\u8054\u7ef4\u62a4", eventDesc="\u5ba2\u6237\u7aef\u5df2\u6388\u6743\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ClientPermissionVo>> list(@ApiParam(value="\u5ba2\u6237\u7aefID") @RequestParam(value="clientId") String clientId) {
        return this.clientPermissionService.listClientPermissions(clientId);
    }
}

