/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.dto.ClientPermissionDto;
import com.jxdinfo.hussar.iam.client.manager.AddClientPermissionManager;
import com.jxdinfo.hussar.iam.client.manager.impl.CommonClientPermissionManager;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.client.manager.impl.addClientPermissionManagerImpl")
public class AddClientPermissionManagerImpl
extends CommonClientPermissionManager
implements AddClientPermissionManager {
    @Override
    @HussarTransactional
    public Boolean saveClientPermissionBatch(List<ClientPermissionDto> list) {
        if (ToolUtil.isEmpty(list)) {
            throw new BaseException("\u5ba2\u6237\u7aef\u6388\u6743\u8d44\u6e90\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<SysClientPermission> addList = new ArrayList<SysClientPermission>();
        List<String> clientIdList = new ArrayList<String>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long tenantId = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantId()) ? securityUser.getTenantId() : Long.parseLong("0");
        for (ClientPermissionDto clientPermissionDto : list) {
            String clientId = clientPermissionDto.getClientId();
            Long resourceId = clientPermissionDto.getResourceId();
            if (ToolUtil.isEmpty((Object)clientId)) continue;
            if (ToolUtil.isNotEmpty((Object)resourceId)) {
                SysClientPermission clientPermission = new SysClientPermission();
                clientPermission.setClientId(clientId);
                clientPermission.setPermissionId(resourceId);
                clientPermission.setScope("permission_list");
                clientPermission.setTenantId(tenantId);
                addList.add(clientPermission);
            }
            clientIdList.add(clientId);
        }
        if (ToolUtil.isNotEmpty(clientIdList)) {
            clientIdList = clientIdList.stream().distinct().collect(Collectors.toList());
            this.sysClientPermissionService.remove((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysClientPermission::getClientId, clientIdList));
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.sysClientPermissionService.saveBatch(addList);
        }
        this.updateClientPermission(addList, clientIdList);
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean addOrDelClientPermission(List<ClientPermissionDto> addList, List<ClientPermissionDto> delList) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long tenantId = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantId()) ? securityUser.getTenantId() : Long.parseLong("0");
        if (ToolUtil.isNotEmpty(addList)) {
            this.addClientPermission(addList, tenantId);
        }
        if (ToolUtil.isNotEmpty(delList)) {
            this.delClientPermission(delList);
        }
        this.updateClientPermissionByAddDel(addList, delList);
        return true;
    }

    private void addClientPermission(List<ClientPermissionDto> addList, Long tenantId) {
        ArrayList<SysClientPermission> addPermissionList = new ArrayList<SysClientPermission>();
        List<SysClientPermission> currentPermissionList = this.sysClientPermissionMapper.getCurrentPermissionList(LambdaQueryUtil.getSplitList(addList));
        for (ClientPermissionDto clientPermissionDto : addList) {
            boolean addFlag = true;
            String clientId = clientPermissionDto.getClientId();
            Long resourceId = clientPermissionDto.getResourceId();
            if (ToolUtil.isEmpty((Object)clientId) || ToolUtil.isEmpty((Object)resourceId)) continue;
            for (SysClientPermission clientPermission : currentPermissionList) {
                if (!clientId.equals(clientPermission.getClientId()) || !resourceId.equals(clientPermission.getPermissionId())) continue;
                addFlag = false;
                break;
            }
            if (!addFlag) continue;
            SysClientPermission clientPermission = new SysClientPermission();
            clientPermission.setClientId(clientId);
            clientPermission.setPermissionId(resourceId);
            clientPermission.setScope("permission_list");
            clientPermission.setTenantId(tenantId);
            addPermissionList.add(clientPermission);
        }
        if (ToolUtil.isNotEmpty(addPermissionList)) {
            this.sysClientPermissionService.saveBatch(addPermissionList);
        }
    }

    private void delClientPermission(List<ClientPermissionDto> delList) {
        this.sysClientPermissionMapper.deletePermissions(LambdaQueryUtil.getSplitList(delList));
    }
}

