/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.manager.AddClientModelManager;
import com.jxdinfo.hussar.iam.client.manager.impl.CommonClientModelManager;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.client.manager.impl.addClientModelManagerImpl")
public class AddClientModelManagerImpl
extends CommonClientModelManager
implements AddClientModelManager {
    @Autowired(required=false)
    private ISysTenantSecureService sysTenantSecureService;

    @Override
    @HussarTransactional
    public ClientVo save(ClientDto clientDto) throws Exception {
        this.checkSaveOrUpdate(clientDto);
        SysClientModel clientModel = this.clientDtoToModel(clientDto);
        clientModel.setClientStatus("1");
        SysAuthClientModel authClientModel = this.clientDtoToAuthModel(clientDto, true);
        if (!this.sysClientModelService.save((Object)clientModel)) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        this.sysAuthClientModelService.saveAuthClientModel(authClientModel);
        HussarFixedCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return this.clientModelToVo(clientModel);
    }

    @Override
    @HussarDs(value="#connName")
    @HussarTransactional
    public ClientVo save(String connName, ClientDto clientDto) throws Exception {
        long count;
        SysTenantSecure tenantSecure;
        if (this.sysTenantSecureService != null && HussarUtils.isNotEmpty((Object)(tenantSecure = (SysTenantSecure)this.sysTenantSecureService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getClientId, (Object)clientDto.getClientId())))) && (count = this.sysTenantSecureService.count((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getClientId, (Object)clientDto.getClientId()))) > 0L) {
            throw new BaseException("\u5ba2\u6237\u7aefID\u5df2\u7ecf\u5b58\u5728");
        }
        this.checkSaveOrUpdate(connName, clientDto);
        SysClientModel clientModel = this.clientDtoToModel(clientDto);
        clientModel.setClientStatus("1");
        SysAuthClientModel authClientModel = this.clientDtoToAuthModel(clientDto, true);
        if (!this.sysClientModelService.save(connName, (Object)clientModel)) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        this.sysAuthClientModelService.saveAuthClientModel(connName, authClientModel);
        HussarFixedCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return this.clientModelToVo(clientModel);
    }
}

